/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;

public class DynamoDBReflectionUtils {
    private static final Log log = LogFactory.getLog(DynamoDBReflectionUtils.class);

    public static <T> T createInstanceOf(String className, Configuration conf) {
        return DynamoDBReflectionUtils.createInstanceOfWithParams(className, conf, null, null);
    }

    public static <T> T createInstanceOfWithParams(String className, Configuration conf, Class<?>[] paramTypes, Object[] params) {
        try {
            Class<?> clazz = DynamoDBReflectionUtils.getClass(className);
            Constructor<?> ctor = paramTypes == null ? clazz.getDeclaredConstructor(new Class[0]) : clazz.getDeclaredConstructor(paramTypes);
            ctor.setAccessible(true);
            Object instance = ctor.newInstance(params);
            log.info((Object)("Successfully loaded class: " + className));
            ReflectionUtils.setConf(instance, (Configuration)conf);
            log.debug((Object)"Configured instance to use conf");
            return (T)instance;
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to find constructor of class: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Class being loaded is not accessible: " + className, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate class: " + className, e);
        }
    }

    public static boolean hasFactoryMethod(String className, String methodName) {
        Class<?> clazz = DynamoDBReflectionUtils.getClass(className);
        return Arrays.stream(clazz.getMethods()).anyMatch(method -> method.getName().equals(methodName));
    }

    public static <T> T createInstanceFromFactory(String className, Configuration conf, String methodName) {
        try {
            Class<?> clazz = DynamoDBReflectionUtils.getClass(className);
            Method m = clazz.getDeclaredMethod(methodName, new Class[0]);
            m.setAccessible(true);
            Object instance = m.invoke(null, new Object[0]);
            log.info((Object)("Successfully loaded class: " + className));
            ReflectionUtils.setConf((Object)instance, (Configuration)conf);
            log.debug((Object)"Configured instance to use conf");
            return (T)instance;
        }
        catch (NoSuchMethodException e) {
            log.error((Object)("Method not found for object construction: " + methodName));
            throw new RuntimeException("Unable to find static method to load class: " + className, e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)("Exception found when invoking method for object construction: " + methodName));
            throw new RuntimeException("Unable to load class: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Class being loaded is not accessible: " + className, e);
        }
    }

    private static Class<?> getClass(String className) {
        try {
            return Class.forName(className, true, DynamoDBReflectionUtils.getContextOrDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to locate class to load via reflection: " + className, e);
        }
    }

    private static ClassLoader getContextOrDefaultClassLoader() {
        return Optional.of(Thread.currentThread().getContextClassLoader()).orElseGet(DynamoDBReflectionUtils::getDefaultClassLoader);
    }

    private static ClassLoader getDefaultClassLoader() {
        return DynamoDBReflectionUtils.class.getClassLoader();
    }
}

