/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.type;

import java.nio.ByteBuffer;
import java.util.stream.Collectors;
import org.apache.hadoop.dynamodb.DynamoDBUtil;
import org.apache.hadoop.dynamodb.key.DynamoDBKey;
import org.apache.hadoop.dynamodb.type.DynamoDBType;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class DynamoDBBinarySetType
implements DynamoDBType {
    @Override
    public AttributeValue getAttributeValue(String ... values) {
        return AttributeValue.fromBs(DynamoDBUtil.base64StringToByteBuffer(values).stream().map(byteBuffer -> SdkBytes.fromByteBuffer((ByteBuffer)byteBuffer)).collect(Collectors.toList()));
    }

    @Override
    public String getDynamoDBType() {
        return "BS";
    }

    @Override
    public DynamoDBKey getKey(String key) {
        throw new RuntimeException("Unexpected type " + this.getDynamoDBType());
    }
}

