/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.read;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dynamodb.DynamoDBClient;
import org.apache.hadoop.dynamodb.DynamoDBConstants;
import org.apache.hadoop.dynamodb.IopsCalculator;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;

public class ReadIopsCalculator
implements IopsCalculator {
    private static final Log log = LogFactory.getLog(ReadIopsCalculator.class);
    private final DynamoDBClient dynamoDBClient;
    private final JobClient jobClient;
    private final JobConf jobConf;
    private final String tableName;
    private final double throughputPercent;
    private final int totalSegments;
    private final int localSegments;

    public ReadIopsCalculator(JobClient jobClient, DynamoDBClient dynamoDBClient, String tableName, int totalSegments, int localSegments) {
        this.jobConf = (JobConf)jobClient.getConf();
        this.jobClient = jobClient;
        this.dynamoDBClient = dynamoDBClient;
        this.tableName = tableName;
        this.totalSegments = totalSegments;
        this.localSegments = localSegments;
        this.throughputPercent = Double.parseDouble(this.jobConf.get("dynamodb.throughput.read.percent", "0.5"));
        log.info((Object)("Table name: " + tableName));
        log.info((Object)("Throughput percent: " + this.throughputPercent));
    }

    @Override
    public long calculateTargetIops() {
        double configuredThroughput = Boolean.parseBoolean(this.jobConf.get("dynamodb.throughput.read.autoscaling")) || this.jobConf.get("dynamodb.throughput.read") == null ? this.getThroughput() : Double.parseDouble(this.jobConf.get("dynamodb.throughput.read"));
        double calculatedThroughput = Math.floor(configuredThroughput * this.throughputPercent);
        long throughputPerTask = Math.max((long)(calculatedThroughput / (double)this.totalSegments * (double)this.localSegments), 1L);
        log.info((Object)("Throughput per task for table " + this.tableName + " : " + throughputPerTask));
        return throughputPerTask;
    }

    protected double getThroughput() {
        TableDescription tableDescription = this.dynamoDBClient.describeTable(this.tableName);
        if (tableDescription.billingModeSummary() == null || tableDescription.billingModeSummary().billingMode() == BillingMode.PROVISIONED) {
            ProvisionedThroughputDescription provisionedThroughput = tableDescription.provisionedThroughput();
            return provisionedThroughput.readCapacityUnits().longValue();
        }
        return DynamoDBConstants.DEFAULT_CAPACITY_FOR_ON_DEMAND.longValue();
    }
}

