/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.preader;

import java.util.Map;
import org.apache.hadoop.dynamodb.DynamoDBFibonacciRetryer;
import org.apache.hadoop.dynamodb.preader.AbstractReadManager;
import org.apache.hadoop.dynamodb.preader.AbstractRecordReadRequest;
import org.apache.hadoop.dynamodb.preader.DynamoDBRecordReaderContext;
import org.apache.hadoop.dynamodb.preader.PageResults;
import org.apache.hadoop.dynamodb.preader.RateController;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class ScanRecordReadRequest
extends AbstractRecordReadRequest {
    public ScanRecordReadRequest(AbstractReadManager readMgr, DynamoDBRecordReaderContext context, int segment, Map<String, AttributeValue> lastEvaluatedKey) {
        super(readMgr, context, segment, lastEvaluatedKey);
    }

    @Override
    protected AbstractRecordReadRequest buildNextReadRequest(PageResults<Map<String, AttributeValue>> pageResults) {
        return new ScanRecordReadRequest(this.readMgr, this.context, this.segment, (Map)pageResults.lastEvaluatedKey);
    }

    @Override
    protected PageResults<Map<String, AttributeValue>> fetchPage(RateController.RequestLimit lim) {
        DynamoDBFibonacciRetryer.RetryResult<ScanResponse> retryResult = this.context.getClient().scanTable(this.tableName, null, this.segment, this.context.getSplit().getTotalSegments(), this.lastEvaluatedKey, lim.items, this.context.getReporter());
        ScanResponse response = (ScanResponse)retryResult.result;
        int retries = retryResult.retries;
        double consumedCapacityUnits = 0.0;
        if (response.consumedCapacity() != null) {
            consumedCapacityUnits = response.consumedCapacity().capacityUnits();
        }
        return new PageResults<Map<String, AttributeValue>>(response.items(), response.hasLastEvaluatedKey() ? response.lastEvaluatedKey() : null, consumedCapacityUnits, retries);
    }
}

