/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.preader;

import java.util.Map;
import org.apache.hadoop.dynamodb.DynamoDBFibonacciRetryer;
import org.apache.hadoop.dynamodb.preader.AbstractReadManager;
import org.apache.hadoop.dynamodb.preader.AbstractRecordReadRequest;
import org.apache.hadoop.dynamodb.preader.DynamoDBRecordReaderContext;
import org.apache.hadoop.dynamodb.preader.PageResults;
import org.apache.hadoop.dynamodb.preader.RateController;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

public class QueryRecordReadRequest
extends AbstractRecordReadRequest {
    public QueryRecordReadRequest(AbstractReadManager readMgr, DynamoDBRecordReaderContext context, Map<String, AttributeValue> lastEvaluatedKey) {
        super(readMgr, context, 0, lastEvaluatedKey);
    }

    @Override
    protected AbstractRecordReadRequest buildNextReadRequest(PageResults<Map<String, AttributeValue>> pageResults) {
        return new QueryRecordReadRequest(this.readMgr, this.context, (Map)pageResults.lastEvaluatedKey);
    }

    @Override
    protected PageResults<Map<String, AttributeValue>> fetchPage(RateController.RequestLimit lim) {
        DynamoDBFibonacciRetryer.RetryResult<QueryResponse> retryResult = this.context.getClient().queryTable(this.tableName, this.context.getSplit().getFilterPushdown(), this.lastEvaluatedKey, lim.items, this.context.getReporter());
        QueryResponse response = (QueryResponse)retryResult.result;
        int retries = retryResult.retries;
        return new PageResults<Map<String, AttributeValue>>(response.items(), response.hasLastEvaluatedKey() ? response.lastEvaluatedKey() : null, response.consumedCapacity().capacityUnits(), retries);
    }
}

