/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.preader;

import java.util.Map;
import org.apache.hadoop.dynamodb.preader.AbstractReadManager;
import org.apache.hadoop.dynamodb.preader.DynamoDBRecordReaderContext;
import org.apache.hadoop.dynamodb.preader.PageResults;
import org.apache.hadoop.dynamodb.preader.RateController;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public abstract class AbstractRecordReadRequest {
    protected final AbstractReadManager readMgr;
    protected final DynamoDBRecordReaderContext context;
    protected final Map<String, AttributeValue> lastEvaluatedKey;
    protected final int segment;
    protected final String tableName;

    public AbstractRecordReadRequest(AbstractReadManager readMgr, DynamoDBRecordReaderContext context, int segment, Map<String, AttributeValue> lastEvaluatedKey) {
        this.readMgr = readMgr;
        this.context = context;
        this.tableName = context.getConf().get("dynamodb.input.tableName");
        this.segment = segment;
        this.lastEvaluatedKey = lastEvaluatedKey;
    }

    public void read(RateController.RequestLimit lim) {
        this.signalProgress();
        PageResults<Map<String, AttributeValue>> pageResults = this.readNextPage(lim);
        this.addPageToMultiplexer(pageResults);
        this.reportMetrics(lim, pageResults);
        this.enqueueNextPageOrCompleteSegment(pageResults);
    }

    private void reportMetrics(RateController.RequestLimit lim, PageResults<Map<String, AttributeValue>> pageResults) {
        if (!pageResults.isFailed()) {
            this.readMgr.report(lim.readCapacityUnits, pageResults.consumedRcu, pageResults.items.size(), pageResults.retries);
        }
    }

    private void signalProgress() {
        this.context.getReporter().progress();
    }

    protected abstract AbstractRecordReadRequest buildNextReadRequest(PageResults<Map<String, AttributeValue>> var1);

    protected abstract PageResults<Map<String, AttributeValue>> fetchPage(RateController.RequestLimit var1);

    private PageResults<Map<String, AttributeValue>> readNextPage(RateController.RequestLimit lim) {
        try {
            return this.fetchPage(lim);
        }
        catch (Exception e) {
            return new PageResults<Map<String, AttributeValue>>(e);
        }
    }

    private void addPageToMultiplexer(PageResults<Map<String, AttributeValue>> pageResults) {
        if (!this.context.getPageResultMultiplexer().addPageResults(pageResults)) {
            throw new RuntimeException("Interrupted while adding to the page mux. Aborting.");
        }
    }

    private void enqueueNextPageOrCompleteSegment(PageResults<Map<String, AttributeValue>> pageResults) {
        if (pageResults.lastEvaluatedKey != null) {
            this.readMgr.enqueueReadRequestToTail(this.buildNextReadRequest(pageResults));
        } else {
            this.readMgr.markSegmentComplete(this.segment);
        }
    }
}

