/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.key;

import java.nio.ByteBuffer;
import org.apache.hadoop.dynamodb.DynamoDBUtil;
import org.apache.hadoop.dynamodb.key.AbstractDynamoDBKey;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class DynamoDBBinaryKey
extends AbstractDynamoDBKey {
    private final ByteBuffer byteBuffer;

    public DynamoDBBinaryKey(String base64EncodedKey) {
        super(base64EncodedKey);
        this.byteBuffer = ByteBuffer.wrap(DynamoDBUtil.base64DecodeString(base64EncodedKey));
    }

    @Override
    public int compareValue(AttributeValue attribute) {
        return this.byteBuffer.compareTo(attribute.b().asByteBuffer());
    }
}

