/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dynamodb.AttributeValueDeserializer;
import org.apache.hadoop.dynamodb.AttributeValueSerializer;
import org.apache.hadoop.dynamodb.DynamoDBConstants;
import org.apache.hadoop.dynamodb.util.ClusterTopologyNodeCapacityProvider;
import org.apache.hadoop.dynamodb.util.DynamoDBReflectionUtils;
import org.apache.hadoop.dynamodb.util.RoundRobinYarnContainerAllocator;
import org.apache.hadoop.dynamodb.util.TaskCalculator;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.regions.internal.util.EC2MetadataUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;

public final class DynamoDBUtil {
    public static final String CHARACTER_ENCODING = "UTF-8";
    private static final Log log = LogFactory.getLog(DynamoDBUtil.class);
    private static final Gson gson;

    public static Double calculateAverageItemSize(TableDescription description) {
        if (description.itemCount() != 0L) {
            return (double)description.tableSizeBytes().longValue() / (double)description.itemCount().longValue();
        }
        return 0.0;
    }

    public static String base64EncodeByteArray(byte[] bytes) {
        try {
            byte[] encodeBase64 = Base64.encodeBase64((byte[])bytes);
            return new String(encodeBase64, CHARACTER_ENCODING);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while encoding bytes: " + Arrays.toString(bytes));
        }
    }

    public static byte[] base64DecodeString(String base64String) {
        try {
            return Base64.decodeBase64((byte[])base64String.getBytes(CHARACTER_ENCODING));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while decoding " + base64String);
        }
    }

    public static ByteBuffer base64StringToByteBuffer(String base64EncodedKey) {
        return ByteBuffer.wrap(DynamoDBUtil.base64DecodeString(base64EncodedKey));
    }

    public static List<ByteBuffer> base64StringToByteBuffer(String ... base64EncodedKeys) {
        ArrayList<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>(base64EncodedKeys.length);
        for (String base64EncodedKey : base64EncodedKeys) {
            byteBuffers.add(DynamoDBUtil.base64StringToByteBuffer(base64EncodedKey));
        }
        return byteBuffers;
    }

    public static Gson getGson() {
        return gson;
    }

    static int getItemSizeBytes(Map<String, AttributeValue> item) {
        try {
            int itemSize = 0;
            for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
                itemSize += entry.getKey() != null ? entry.getKey().getBytes(CHARACTER_ENCODING).length : 0;
                itemSize += entry.getValue() != null ? DynamoDBUtil.getAttributeSizeBytes(entry.getValue()) : 0;
            }
            return itemSize;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void verifyInterval(long intervalBeginTime, long intervalLength) {
        long interval = intervalBeginTime + intervalLength;
        long currentDateTime = new DateTime(DateTimeZone.UTC).getMillis();
        if (currentDateTime < interval) {
            try {
                Thread.sleep(interval - currentDateTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting ", e);
            }
        }
    }

    private static int getAttributeSizeBytes(AttributeValue att) throws UnsupportedEncodingException {
        int byteSize;
        block6: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block5: {
                                        byteSize = 0;
                                        if (att.n() == null) break block5;
                                        byteSize += att.n().getBytes(CHARACTER_ENCODING).length;
                                        break block6;
                                    }
                                    if (att.s() == null) break block7;
                                    byteSize += att.s().getBytes(CHARACTER_ENCODING).length;
                                    break block6;
                                }
                                if (att.b() == null) break block8;
                                byteSize += att.b().asByteArray().length;
                                break block6;
                            }
                            if (!att.hasNs()) break block9;
                            for (String number : att.ns()) {
                                byteSize += number.getBytes(CHARACTER_ENCODING).length;
                            }
                            break block6;
                        }
                        if (!att.hasSs()) break block10;
                        for (String string : att.ss()) {
                            byteSize += string.getBytes(CHARACTER_ENCODING).length;
                        }
                        break block6;
                    }
                    if (!att.hasBs()) break block11;
                    for (SdkBytes sdkBytes : att.bs()) {
                        byteSize += sdkBytes.asByteArray().length;
                    }
                    break block6;
                }
                if (!att.hasM()) break block12;
                for (Map.Entry entry : att.m().entrySet()) {
                    byteSize += DynamoDBUtil.getAttributeSizeBytes((AttributeValue)entry.getValue()) + ((String)entry.getKey()).getBytes(CHARACTER_ENCODING).length;
                }
                break block6;
            }
            if (!att.hasL()) break block6;
            for (AttributeValue entry : att.l()) {
                byteSize += DynamoDBUtil.getAttributeSizeBytes(entry);
            }
        }
        return byteSize;
    }

    static long getBoundedBatchLimit(Configuration config, long batchSize) {
        long maxItemsPerBatch = config.getLong("dynamodb.max.batch.items", 25L);
        return Math.min(Math.max(batchSize, 1L), maxItemsPerBatch);
    }

    public static String getValueFromConf(Configuration conf, String confKey, String defaultValue) {
        if (conf == null) {
            return defaultValue;
        }
        return conf.get(confKey, defaultValue);
    }

    public static String getValueFromConf(Configuration conf, String confKey) {
        return DynamoDBUtil.getValueFromConf(conf, confKey, null);
    }

    public static String getDynamoDBEndpoint(Configuration conf, String region) {
        String endpoint = DynamoDBUtil.getValueFromConf(conf, "dynamodb.endpoint");
        if (Strings.isNullOrEmpty((String)endpoint)) {
            log.info((Object)"dynamodb.endpoint not found from configuration.");
        } else {
            log.info((Object)("Using endpoint for DynamoDB: " + endpoint));
        }
        return endpoint;
    }

    public static String getDynamoDBRegion(Configuration conf, String region) {
        if (!Strings.isNullOrEmpty((String)region)) {
            return region;
        }
        region = DynamoDBUtil.getValueFromConf(conf, "dynamodb.region");
        if (!Strings.isNullOrEmpty((String)region)) {
            return region;
        }
        region = DynamoDBUtil.getValueFromConf(conf, "dynamodb.regionid");
        if (!Strings.isNullOrEmpty((String)region)) {
            return region;
        }
        try {
            region = EC2MetadataUtils.getEC2InstanceRegion();
        }
        catch (Exception e) {
            log.warn((Object)String.format("Exception when attempting to get AWS region information. Will ignore and default to %s", DynamoDBConstants.DEFAULT_AWS_REGION), (Throwable)e);
        }
        if (!Strings.isNullOrEmpty((String)region)) {
            return region;
        }
        return DynamoDBConstants.DEFAULT_AWS_REGION;
    }

    public static AwsCredentialsProvider loadAwsCredentialsProvider(String providerClass, Configuration conf) {
        if (DynamoDBReflectionUtils.hasFactoryMethod(providerClass, "create")) {
            log.debug((Object)("Provider: " + providerClass + " contains required method for creation - create()"));
            return (AwsCredentialsProvider)DynamoDBReflectionUtils.createInstanceFromFactory(providerClass, conf, "create");
        }
        log.debug((Object)"Falling back to default constructor.");
        return (AwsCredentialsProvider)DynamoDBReflectionUtils.createInstanceOf(providerClass, conf);
    }

    public static JobClient createJobClient(JobConf jobConf) {
        try {
            return new JobClient(jobConf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int calcMaxMapTasks(JobClient jobClient) throws IOException {
        JobConf conf = (JobConf)jobClient.getConf();
        ClusterTopologyNodeCapacityProvider nodeCapacityProvider = new ClusterTopologyNodeCapacityProvider(conf);
        RoundRobinYarnContainerAllocator yarnContainerAllocator = new RoundRobinYarnContainerAllocator();
        TaskCalculator taskCalculator = new TaskCalculator(jobClient, nodeCapacityProvider, yarnContainerAllocator);
        return taskCalculator.getMaxMapTasks();
    }

    public static boolean isYarnEnabled(JobConf jobConf) {
        return jobConf.getBoolean("dynamodb.yarn.enabled", true);
    }

    public static boolean isYarnEnabled(Configuration jobConf) {
        return jobConf.getBoolean("dynamodb.yarn.enabled", true);
    }

    public static long calculateEstimateLength(Configuration jobConf, long approxItemCountPerSplit) {
        long averageItemSize = (long)jobConf.getDouble("dynamodb.item.average.size", 0.0);
        long splitSize = jobConf.getLong("dynamodb.split.size", 1L);
        return Math.max(splitSize, averageItemSize * approxItemCountPerSplit);
    }

    private DynamoDBUtil() {
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(ByteBuffer.class, (Object)new ByteBufferSerializer());
        gsonBuilder.registerTypeAdapter(ByteBuffer.class, (Object)new ByteBufferDeserializer());
        gsonBuilder.registerTypeAdapter(SdkBytes.class, (Object)new SdkBytesSerializer());
        gsonBuilder.registerTypeAdapter(SdkBytes.class, (Object)new SdkBytesDeserializer());
        gsonBuilder.registerTypeAdapter(AttributeValue.class, (Object)new AttributeValueSerializer());
        gsonBuilder.registerTypeAdapter(AttributeValue.class, (Object)new AttributeValueDeserializer());
        gson = gsonBuilder.disableHtmlEscaping().create();
    }

    private static class SdkBytesDeserializer
    implements JsonDeserializer<SdkBytes> {
        private SdkBytesDeserializer() {
        }

        public SdkBytes deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            String base64String = jsonElement.getAsJsonPrimitive().getAsString();
            return SdkBytes.fromByteBuffer((ByteBuffer)DynamoDBUtil.base64StringToByteBuffer(base64String));
        }
    }

    private static class SdkBytesSerializer
    implements JsonSerializer<SdkBytes> {
        private SdkBytesSerializer() {
        }

        public JsonElement serialize(SdkBytes sdkBytes, Type type, JsonSerializationContext context) {
            String base64String = DynamoDBUtil.base64EncodeByteArray(sdkBytes.asByteArray());
            return new JsonPrimitive(base64String);
        }
    }

    private static class ByteBufferDeserializer
    implements JsonDeserializer<ByteBuffer> {
        private ByteBufferDeserializer() {
        }

        public ByteBuffer deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            String base64String = jsonElement.getAsJsonPrimitive().getAsString();
            return DynamoDBUtil.base64StringToByteBuffer(base64String);
        }
    }

    private static class ByteBufferSerializer
    implements JsonSerializer<ByteBuffer> {
        private ByteBufferSerializer() {
        }

        public JsonElement serialize(ByteBuffer byteBuffer, Type type, JsonSerializationContext context) {
            String base64String = DynamoDBUtil.base64EncodeByteArray(byteBuffer.array());
            return new JsonPrimitive(base64String);
        }
    }
}

