/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class AttributeValueSerializer
implements JsonSerializer<AttributeValue> {
    public JsonElement serialize(AttributeValue attributeValue, Type type, JsonSerializationContext context) {
        if (attributeValue == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject serializedValue = new JsonObject();
        switch (attributeValue.type()) {
            case B: {
                serializedValue.add(AttributeValueSerializer.toV1FieldCasingStyle("B"), context.serialize((Object)attributeValue.b()));
                break;
            }
            case BOOL: {
                serializedValue.add(AttributeValueSerializer.toV1FieldCasingStyle("BOOL"), (JsonElement)new JsonPrimitive(attributeValue.bool()));
                break;
            }
            case BS: {
                JsonArray sdkBytesList = new JsonArray();
                attributeValue.bs().forEach(item -> sdkBytesList.add(context.serialize(item, SdkBytes.class)));
                serializedValue.add(AttributeValueSerializer.toV1FieldCasingStyle("BS"), (JsonElement)sdkBytesList);
                break;
            }
            case L: {
                JsonArray attributeList = new JsonArray();
                attributeValue.l().forEach(item -> attributeList.add(context.serialize(item, AttributeValue.class)));
                serializedValue.add(AttributeValueSerializer.toV1FieldCasingStyle("L"), (JsonElement)attributeList);
                break;
            }
            case M: {
                JsonObject avm = new JsonObject();
                attributeValue.m().entrySet().forEach(entry -> avm.add((String)entry.getKey(), context.serialize(entry.getValue(), AttributeValue.class)));
                serializedValue.add(AttributeValueSerializer.toV1FieldCasingStyle("M"), (JsonElement)avm);
                break;
            }
            case N: {
                serializedValue.add(AttributeValueSerializer.toV1FieldCasingStyle("N"), (JsonElement)new JsonPrimitive(attributeValue.n()));
                break;
            }
            case NS: {
                JsonArray numberList = new JsonArray();
                attributeValue.ns().forEach(item -> numberList.add((JsonElement)new JsonPrimitive(item)));
                serializedValue.add(AttributeValueSerializer.toV1FieldCasingStyle("NS"), (JsonElement)numberList);
                break;
            }
            case NUL: {
                serializedValue.add(AttributeValueSerializer.toV1FieldCasingStyle("NULL"), (JsonElement)new JsonPrimitive(attributeValue.nul()));
                break;
            }
            case S: {
                serializedValue.add(AttributeValueSerializer.toV1FieldCasingStyle("S"), (JsonElement)new JsonPrimitive(attributeValue.s()));
                break;
            }
            case SS: {
                JsonArray stringList = new JsonArray();
                attributeValue.ss().forEach(item -> stringList.add((JsonElement)new JsonPrimitive(item)));
                serializedValue.add(AttributeValueSerializer.toV1FieldCasingStyle("SS"), (JsonElement)stringList);
                break;
            }
        }
        return serializedValue;
    }

    private static String toV1FieldCasingStyle(String typeConstant) {
        return typeConstant.substring(0, 1).toLowerCase() + typeConstant.substring(1).toUpperCase();
    }
}

