/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class AttributeValueDeserializer
implements JsonDeserializer<AttributeValue> {
    public AttributeValue deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                JsonObject jsonMap;
                JsonArray jsonArray;
                String attributeName = (String)entry.getKey();
                JsonElement attributeValue = (JsonElement)entry.getValue();
                if ("B".equalsIgnoreCase(attributeName)) {
                    return AttributeValue.fromB((SdkBytes)((SdkBytes)context.deserialize(attributeValue, SdkBytes.class)));
                }
                if ("BS".equalsIgnoreCase(attributeName) && !(jsonArray = attributeValue.getAsJsonArray()).isEmpty()) {
                    ArrayList sdkBytesList = new ArrayList();
                    jsonArray.forEach(item -> sdkBytesList.add(context.deserialize(item, SdkBytes.class)));
                    return AttributeValue.fromBs(sdkBytesList);
                }
                if ("BOOL".equalsIgnoreCase(attributeName)) {
                    return AttributeValue.fromBool((Boolean)attributeValue.getAsBoolean());
                }
                if ("NULL".equalsIgnoreCase(attributeName)) {
                    return AttributeValue.fromNul((Boolean)attributeValue.getAsBoolean());
                }
                if ("N".equalsIgnoreCase(attributeName)) {
                    return AttributeValue.fromN((String)attributeValue.getAsString());
                }
                if ("NS".equalsIgnoreCase(attributeName) && !(jsonArray = attributeValue.getAsJsonArray()).isEmpty()) {
                    ArrayList numberList = new ArrayList();
                    jsonArray.forEach(item -> numberList.add(item.getAsString()));
                    return AttributeValue.fromNs(numberList);
                }
                if ("L".equalsIgnoreCase(attributeName) && !(jsonArray = attributeValue.getAsJsonArray()).isEmpty()) {
                    ArrayList avl = new ArrayList();
                    jsonArray.forEach(element -> avl.add(context.deserialize(element, AttributeValue.class)));
                    return AttributeValue.fromL(avl);
                }
                if ("M".equalsIgnoreCase(attributeName) && (jsonMap = attributeValue.getAsJsonObject()).size() != 0) {
                    HashMap avm = new HashMap();
                    jsonMap.entrySet().forEach(item -> avm.put(item.getKey(), context.deserialize((JsonElement)item.getValue(), AttributeValue.class)));
                    return AttributeValue.fromM(avm);
                }
                if ("S".equalsIgnoreCase(attributeName)) {
                    return AttributeValue.fromS((String)attributeValue.getAsString());
                }
                if (!"SS".equalsIgnoreCase(attributeName) || (jsonArray = attributeValue.getAsJsonArray()).isEmpty()) continue;
                ArrayList stringList = new ArrayList();
                jsonArray.forEach(item -> stringList.add(item.getAsString()));
                return AttributeValue.fromSs(stringList);
            }
        }
        return (AttributeValue)AttributeValue.builder().build();
    }
}

