/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dynamodb.util.NodeCapacityProvider;
import org.apache.hadoop.dynamodb.util.YarnContainerAllocator;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;

public class TaskCalculator {
    private static final Log log = LogFactory.getLog(TaskCalculator.class);
    private final JobClient jobClient;
    private final NodeCapacityProvider nodeCapacityProvider;
    private final YarnContainerAllocator yarnContainerAllocator;

    public TaskCalculator(JobClient jobClient, NodeCapacityProvider nodeCapacityProvider, YarnContainerAllocator yarnContainerAllocator) {
        this.jobClient = jobClient;
        this.nodeCapacityProvider = nodeCapacityProvider;
        this.yarnContainerAllocator = yarnContainerAllocator;
    }

    public int getMaxMapTasks() throws IOException {
        JobConf conf = (JobConf)this.jobClient.getConf();
        int nodes = this.jobClient.getClusterStatus().getTaskTrackers();
        log.info((Object)("Cluster has " + nodes + " active nodes."));
        if (nodes == 0) {
            log.warn((Object)"Cluster doesn't have any nodes");
            return 0;
        }
        int slotMemory = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int nodeMemory = this.nodeCapacityProvider.getCoreNodeMemoryMB();
        int nodeSlots = nodeMemory / slotMemory;
        int mapMemory = conf.getInt("mapreduce.map.memory.mb", 1024);
        int mapSlots = (int)Math.ceil((double)mapMemory / (double)slotMemory);
        int amMemory = conf.getInt("yarn.app.mapreduce.am.resource.mb", 1536);
        int appMasterSlots = (int)Math.ceil((double)amMemory / (double)slotMemory);
        int reduceMemory = conf.getInt("mapreduce.reduce.memory.mb", 1024);
        int reduceSlots = (int)Math.ceil((double)reduceMemory / (double)slotMemory);
        int reducers = conf.getNumReduceTasks();
        int mappers = this.yarnContainerAllocator.getMaxMappers(nodes, reducers, nodeSlots, appMasterSlots, mapSlots, reduceSlots);
        log.info((Object)("Slot size: " + slotMemory + "MB."));
        log.info((Object)("Node manager can allocate " + nodeMemory + "MB (" + nodeSlots + " slots) for containers on each node."));
        log.info((Object)("Each mapper needs: " + mapMemory + "MB. (" + mapSlots + " slots)"));
        log.info((Object)("Each reducer needs: " + reduceMemory + "MB. (" + reduceSlots + " slots)"));
        log.info((Object)("MapReduce Application Manager needs: " + amMemory + " MB. (" + appMasterSlots + " slots)"));
        log.info((Object)("Number of reducers: " + reducers));
        log.info((Object)("Max number of cluster map tasks: " + mappers));
        if (mappers < 1) {
            log.warn((Object)"The calculated max number of concurrent map tasks is less than 1. Use 1 instead.");
            mappers = 1;
        }
        return mappers;
    }
}

