/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dynamodb.util.YarnContainerAllocator;

public class RoundRobinYarnContainerAllocator
implements YarnContainerAllocator {
    private static final Log log = LogFactory.getLog(RoundRobinYarnContainerAllocator.class);

    @Override
    public int getMaxMappers(int nodes, int reducers, int nodeSlots, int appMasterSlots, int mapSlots, int reduceSlots) {
        int reducerIndex;
        int[] clusterNodeSlots = new int[nodes];
        for (int k = 0; k < nodes; ++k) {
            clusterNodeSlots[k] = nodeSlots;
        }
        clusterNodeSlots[0] = clusterNodeSlots[0] - appMasterSlots;
        int nodeIndex = 1;
        for (reducerIndex = 0; reducerIndex < reducers; ++reducerIndex) {
            if (nodeIndex >= nodes) {
                nodeIndex = 0;
            }
            if (clusterNodeSlots[nodeIndex] < reduceSlots) break;
            int n = nodeIndex++;
            clusterNodeSlots[n] = clusterNodeSlots[n] - reduceSlots;
        }
        if (reducerIndex < reducers) {
            log.warn((Object)"All slots are used for the app master and reducers. No slots for mappers.");
            return 0;
        }
        int mappers = 0;
        for (nodeIndex = 0; nodeIndex < nodes; ++nodeIndex) {
            mappers += clusterNodeSlots[nodeIndex] / mapSlots;
        }
        return mappers;
    }
}

