/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.read;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dynamodb.DynamoDBClient;
import org.apache.hadoop.dynamodb.DynamoDBUtil;
import org.apache.hadoop.dynamodb.preader.DynamoDBRecordReaderContext;
import org.apache.hadoop.dynamodb.split.DynamoDBSplitGenerator;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;

public abstract class AbstractDynamoDBInputFormat<K, V>
implements InputFormat<K, V> {
    private static final int MIN_READ_THROUGHPUT_PER_MAP = 100;
    private static final Log log = LogFactory.getLog(AbstractDynamoDBInputFormat.class);

    public InputSplit[] getSplits(JobConf conf, int desiredSplits) throws IOException {
        JobClient jobClient = new JobClient(conf);
        int maxClusterMapTasks = DynamoDBUtil.calcMaxMapTasks(jobClient);
        if (maxClusterMapTasks < 1) {
            throw new RuntimeException("Number of map tasks configured for the cluster less than 1. Map tasks: " + maxClusterMapTasks);
        }
        double readPercentage = Double.parseDouble(conf.get("dynamodb.throughput.read.percent", "0.5"));
        if (readPercentage <= 0.0) {
            throw new RuntimeException("Invalid read percentage: " + readPercentage);
        }
        log.info((Object)("Read percentage: " + readPercentage));
        double maxReadThroughputAllocated = conf.getLong("dynamodb.throughput.read", 1L);
        double maxWriteThroughputAllocated = conf.getLong("dynamodb.throughput.write", 1L);
        if (maxReadThroughputAllocated < 1.0) {
            throw new RuntimeException("Read throughput should not be less than 1. Read throughput percent: " + maxReadThroughputAllocated);
        }
        int configuredReadThroughput = (int)Math.floor(maxReadThroughputAllocated * readPercentage);
        if (configuredReadThroughput < 1) {
            configuredReadThroughput = 1;
        }
        long tableSizeBytes = conf.getLong("dynamodb.table.size-bytes", 1L);
        int numSegments = this.getNumSegments((int)maxReadThroughputAllocated, (int)maxWriteThroughputAllocated, tableSizeBytes, conf);
        int numMappers = this.getNumMappers(maxClusterMapTasks, configuredReadThroughput, conf);
        log.info((Object)("Using " + numSegments + " segments across " + numMappers + " mappers"));
        return this.getSplitGenerator().generateSplits(numMappers, numSegments, conf);
    }

    protected DynamoDBRecordReaderContext buildDynamoDBRecordReaderContext(InputSplit split, JobConf conf, Reporter reporter) {
        DynamoDBRecordReaderContext context = new DynamoDBRecordReaderContext();
        context.setConf(conf);
        context.setSplit(split);
        context.setClient(new DynamoDBClient((Configuration)conf));
        context.setAverageItemSize(conf.getFloat("dynamodb.item.average.size", 0.0f));
        context.setReporter(reporter);
        return context;
    }

    protected int getNumSegments(int tableNormalizedReadThroughput, int tableNormalizedWriteThroughput, long currentTableSizeBytes, JobConf conf) throws IOException {
        int numSegments = conf.getInt("dynamodb.scan.segments", -1);
        if (numSegments >= 1) {
            numSegments = Math.min(numSegments, 1000000);
            numSegments = Math.max(numSegments, 1);
            log.info((Object)("Using number of segments configured using dynamodb.scan.segments: " + numSegments));
            return numSegments;
        }
        int numSegmentsForSize = (int)(currentTableSizeBytes / 0x40000000L);
        log.info((Object)("Would use " + numSegmentsForSize + " segments for size"));
        int numSegmentsForThroughput = (int)((double)tableNormalizedReadThroughput / 100.0);
        log.info((Object)("Would use " + numSegmentsForThroughput + " segments for throughput"));
        numSegments = Math.max(numSegmentsForSize, numSegmentsForThroughput);
        numSegments = Math.min(numSegments, 1000000);
        numSegments = Math.max(numSegments, 1);
        log.info((Object)("Using computed number of segments: " + numSegments));
        return numSegments;
    }

    protected int getNumMappers(int maxClusterMapTasks, int configuredReadThroughput, JobConf conf) throws IOException {
        int maxSplits;
        log.info((Object)("Max number of cluster map tasks: " + maxClusterMapTasks));
        log.info((Object)("Configured read throughput: " + configuredReadThroughput));
        int numMappers = maxClusterMapTasks;
        int maxMapTasksForThroughput = configuredReadThroughput / 100;
        if (maxMapTasksForThroughput < maxClusterMapTasks) {
            numMappers = maxMapTasksForThroughput;
        }
        if (numMappers > (maxSplits = Math.min(1000000, conf.getInt("dynamodb.max.map.tasks", 1000000)))) {
            log.info((Object)("Max number of splits: " + maxSplits));
            numMappers = maxSplits;
        }
        numMappers = Math.max(numMappers, 1);
        log.info((Object)("Calculated to use " + numMappers + " mappers"));
        return numMappers;
    }

    protected DynamoDBSplitGenerator getSplitGenerator() {
        return new DynamoDBSplitGenerator();
    }
}

