/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.preader;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.util.Map;
import org.apache.hadoop.dynamodb.DynamoDBFibonacciRetryer;
import org.apache.hadoop.dynamodb.preader.AbstractReadManager;
import org.apache.hadoop.dynamodb.preader.AbstractRecordReadRequest;
import org.apache.hadoop.dynamodb.preader.DynamoDBRecordReaderContext;
import org.apache.hadoop.dynamodb.preader.PageResults;
import org.apache.hadoop.dynamodb.preader.RateController;

public class ScanRecordReadRequest
extends AbstractRecordReadRequest {
    public ScanRecordReadRequest(AbstractReadManager readMgr, DynamoDBRecordReaderContext context, int segment, Map<String, AttributeValue> lastEvaluatedKey) {
        super(readMgr, context, segment, lastEvaluatedKey);
    }

    @Override
    protected AbstractRecordReadRequest buildNextReadRequest(PageResults<Map<String, AttributeValue>> pageResults) {
        return new ScanRecordReadRequest(this.readMgr, this.context, this.segment, (Map)pageResults.lastEvaluatedKey);
    }

    @Override
    protected PageResults<Map<String, AttributeValue>> fetchPage(RateController.RequestLimit lim) {
        DynamoDBFibonacciRetryer.RetryResult<ScanResult> retryResult = this.context.getClient().scanTable(this.tableName, null, this.segment, this.context.getSplit().getTotalSegments(), this.lastEvaluatedKey, lim.items, this.context.getReporter());
        ScanResult result = (ScanResult)retryResult.result;
        int retries = retryResult.retries;
        return new PageResults<Map<String, AttributeValue>>(result.getItems(), result.getLastEvaluatedKey(), result.getConsumedCapacity().getCapacityUnits(), retries);
    }
}

