/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.preader;

import org.apache.hadoop.dynamodb.preader.AbstractReadManager;
import org.apache.hadoop.dynamodb.preader.DynamoDBRecordReaderContext;
import org.apache.hadoop.dynamodb.preader.QueryRecordReadRequest;
import org.apache.hadoop.dynamodb.preader.RateController;
import org.apache.hadoop.dynamodb.util.AbstractTimeSource;

public class QueryReadManager
extends AbstractReadManager {
    public QueryReadManager(RateController rateController, AbstractTimeSource time, DynamoDBRecordReaderContext context) {
        super(rateController, time, context);
    }

    @Override
    protected void initializeReadRequests() {
        int totalSegments = this.context.getSplit().getTotalSegments();
        if (totalSegments != 1) {
            String errorMsg = "Expect 1 segment for query (received " + this.context.getSplit().getTotalSegments() + ")";
            log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        this.segmentsRemaining.set(totalSegments);
        this.enqueueReadRequestToTail(new QueryRecordReadRequest(this, this.context, null));
    }
}

