/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.preader;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import java.util.Map;
import org.apache.hadoop.dynamodb.DynamoDBFibonacciRetryer;
import org.apache.hadoop.dynamodb.preader.AbstractReadManager;
import org.apache.hadoop.dynamodb.preader.AbstractRecordReadRequest;
import org.apache.hadoop.dynamodb.preader.DynamoDBRecordReaderContext;
import org.apache.hadoop.dynamodb.preader.PageResults;
import org.apache.hadoop.dynamodb.preader.RateController;

public class QueryRecordReadRequest
extends AbstractRecordReadRequest {
    public QueryRecordReadRequest(AbstractReadManager readMgr, DynamoDBRecordReaderContext context, Map<String, AttributeValue> lastEvaluatedKey) {
        super(readMgr, context, 0, lastEvaluatedKey);
    }

    @Override
    protected AbstractRecordReadRequest buildNextReadRequest(PageResults<Map<String, AttributeValue>> pageResults) {
        return new QueryRecordReadRequest(this.readMgr, this.context, (Map)pageResults.lastEvaluatedKey);
    }

    @Override
    protected PageResults<Map<String, AttributeValue>> fetchPage(RateController.RequestLimit lim) {
        DynamoDBFibonacciRetryer.RetryResult<QueryResult> retryResult = this.context.getClient().queryTable(this.tableName, this.context.getSplit().getFilterPushdown(), this.lastEvaluatedKey, lim.items, this.context.getReporter());
        QueryResult result = (QueryResult)retryResult.result;
        int retries = retryResult.retries;
        return new PageResults<Map<String, AttributeValue>>(result.getItems(), result.getLastEvaluatedKey(), result.getConsumedCapacity().getCapacityUnits(), retries);
    }
}

