/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.preader;

import java.util.List;

public class PageResults<V> {
    public final List<V> items;
    public final V lastEvaluatedKey;
    public final double consumedRcu;
    public final int retries;
    public final Exception exception;
    private volatile int pos;

    public PageResults(List<V> items, V lastEvaluatedKey, double consumedRcu, int retries) {
        if (items == null) {
            throw new IllegalArgumentException("Items must not be null");
        }
        this.items = items;
        this.lastEvaluatedKey = lastEvaluatedKey;
        this.consumedRcu = consumedRcu;
        this.retries = retries;
        this.exception = null;
    }

    public PageResults(List<V> items, V lastEvaluatedKey) {
        this(items, lastEvaluatedKey, 0.0, 0);
    }

    public PageResults(Exception exception) {
        if (exception == null) {
            throw new IllegalArgumentException("exception must not be null");
        }
        this.items = null;
        this.lastEvaluatedKey = null;
        this.consumedRcu = 0.0;
        this.retries = 0;
        this.exception = exception;
    }

    public V next() {
        if (this.hasMore()) {
            return this.items.get(this.pos++);
        }
        return null;
    }

    public boolean hasMore() {
        return this.pos < this.items.size();
    }
}

