/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.preader;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.Map;
import org.apache.hadoop.dynamodb.preader.AbstractReadManager;
import org.apache.hadoop.dynamodb.preader.DynamoDBRecordReaderContext;
import org.apache.hadoop.dynamodb.preader.PageResults;
import org.apache.hadoop.dynamodb.preader.RateController;

public abstract class AbstractRecordReadRequest {
    protected final AbstractReadManager readMgr;
    protected final DynamoDBRecordReaderContext context;
    protected final Map<String, AttributeValue> lastEvaluatedKey;
    protected final int segment;
    protected final String tableName;

    public AbstractRecordReadRequest(AbstractReadManager readMgr, DynamoDBRecordReaderContext context, int segment, Map<String, AttributeValue> lastEvaluatedKey) {
        this.readMgr = readMgr;
        this.context = context;
        this.tableName = context.getConf().get("dynamodb.input.tableName");
        this.segment = segment;
        this.lastEvaluatedKey = lastEvaluatedKey;
    }

    public void read(RateController.RequestLimit lim) {
        this.context.getReporter().progress();
        PageResults<Map<String, AttributeValue>> pageResults = this.fetchPage(lim);
        boolean added = this.context.getPageResultMultiplexer().addPageResults(pageResults);
        if (!added) {
            throw new RuntimeException("Interrupted while adding to the page mux. Aborting.");
        }
        this.readMgr.report(lim.readCapacityUnits, pageResults.consumedRcu, pageResults.items.size(), pageResults.retries);
        if (pageResults.lastEvaluatedKey != null) {
            this.readMgr.enqueueReadRequestToTail(this.buildNextReadRequest(pageResults));
        } else {
            this.readMgr.markSegmentComplete(this.segment);
        }
    }

    protected abstract AbstractRecordReadRequest buildNextReadRequest(PageResults<Map<String, AttributeValue>> var1);

    protected abstract PageResults<Map<String, AttributeValue>> fetchPage(RateController.RequestLimit var1);
}

