/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.filter;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.dynamodb.filter.DynamoDBFilterOperatorType;

public enum DynamoDBFilterOperator {
    EQ(DynamoDBFilterOperatorType.BINARY, "=", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFEqual", "EQ", 1),
    IN(DynamoDBFilterOperatorType.NARY, "in", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn", "IN", 2),
    BETWEEN(DynamoDBFilterOperatorType.NARY, null, null, "BETWEEN", 3),
    LE(DynamoDBFilterOperatorType.BINARY, "<=", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOPEqualOrLessThan", "LE", 4),
    GE(DynamoDBFilterOperatorType.BINARY, ">=", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOPEqualOrGreaterThan", "GE", 5),
    LT(DynamoDBFilterOperatorType.BINARY, "<", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOPLessThan", "LT", 6),
    GT(DynamoDBFilterOperatorType.BINARY, ">", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOPGreaterThan", "GT", 7),
    NE(DynamoDBFilterOperatorType.BINARY, "<>", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOPNotEqual", "NE", 8),
    N_NULL(DynamoDBFilterOperatorType.UNARY, "isnull", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOPNotNull", "NOT_NULL", 9),
    NULL(DynamoDBFilterOperatorType.UNARY, "isnotnull", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOPNull", "NULL", 10);

    private static final Map<String, DynamoDBFilterOperator> operatorSymbolMap;
    private static final Map<String, DynamoDBFilterOperator> hiveClassMap;
    private final DynamoDBFilterOperatorType type;
    private final String operatorSymbol;
    private final String hiveClass;
    private final String dynamoDBName;
    private final int precedenceNumber;

    private DynamoDBFilterOperator(DynamoDBFilterOperatorType type, String operatorSymbol, String hiveClass, String dynamoDBName, int precedenceNumber) {
        this.type = type;
        this.operatorSymbol = operatorSymbol;
        this.hiveClass = hiveClass;
        this.dynamoDBName = dynamoDBName;
        this.precedenceNumber = precedenceNumber;
    }

    public static DynamoDBFilterOperator getFilterOperationFromOperatorSymbol(String comparisonOp) {
        return operatorSymbolMap.get(comparisonOp);
    }

    public static DynamoDBFilterOperator getFilterOperationFromHiveClass(String comparisonOp) {
        return hiveClassMap.get(comparisonOp);
    }

    public DynamoDBFilterOperatorType getType() {
        return this.type;
    }

    public String getHiveClass() {
        return this.hiveClass;
    }

    public String getOperatorSymbol() {
        return this.operatorSymbol;
    }

    public String getDynamoDBName() {
        return this.dynamoDBName;
    }

    public boolean isLowerPrecedence(DynamoDBFilterOperator op) {
        return this.precedenceNumber > op.precedenceNumber;
    }

    static {
        operatorSymbolMap = new HashMap<String, DynamoDBFilterOperator>();
        hiveClassMap = new HashMap<String, DynamoDBFilterOperator>();
        for (DynamoDBFilterOperator op : DynamoDBFilterOperator.values()) {
            operatorSymbolMap.put(op.getOperatorSymbol(), op);
            hiveClassMap.put(op.getHiveClass(), op);
        }
    }
}

