/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer.handle;

import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.writer.Group;
import com.alicloud.openservices.tablestore.writer.RequestWithGroups;
import com.alicloud.openservices.tablestore.writer.RowChangeWithGroup;
import com.alicloud.openservices.tablestore.writer.RowWriteResult;
import com.alicloud.openservices.tablestore.writer.WriterConfig;
import com.alicloud.openservices.tablestore.writer.config.BucketConfig;
import com.alicloud.openservices.tablestore.writer.handle.BaseRequestManager;
import com.alicloud.openservices.tablestore.writer.handle.WriterHandleStatistics;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchWriteRowRequestManager
extends BaseRequestManager {
    private Logger logger = LoggerFactory.getLogger(BatchWriteRowRequestManager.class);

    public BatchWriteRowRequestManager(AsyncClientInterface ots, WriterConfig writerConfig, BucketConfig bucketConfig, Executor executor, WriterHandleStatistics writerStatistics, TableStoreCallback<RowChange, RowWriteResult> callback, Semaphore callbackSemaphore, Semaphore bucketSemaphore) {
        super(ots, writerConfig, bucketConfig, executor, writerStatistics, callback, callbackSemaphore, bucketSemaphore);
    }

    @Override
    public RequestWithGroups makeRequest() {
        if (this.rowChangeWithGroups.size() > 0) {
            BatchWriteRowRequest request = new BatchWriteRowRequest();
            ArrayList<Group> groupFutureList = new ArrayList<Group>(this.rowChangeWithGroups.size());
            for (RowChangeWithGroup rowChangeWithGroup : this.rowChangeWithGroups) {
                request.addRowChange(rowChangeWithGroup.rowChange);
                groupFutureList.add(rowChangeWithGroup.group);
            }
            this.clear();
            return new RequestWithGroups(request, groupFutureList);
        }
        return null;
    }

    @Override
    public void sendRequest(RequestWithGroups requestWithGroups) {
        BatchWriteRowRequest finalRequest = (BatchWriteRowRequest)requestWithGroups.getRequest();
        List<Group> finalGroupFuture = requestWithGroups.getGroupList();
        this.ots.batchWriteRow(finalRequest, this.callbackFactory.newInstance(finalGroupFuture));
    }
}

