/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeserieswriter;

import com.alicloud.openservices.tablestore.AsyncTimeseriesClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesTableRow;
import com.alicloud.openservices.tablestore.timeserieswriter.TimeseriesRowEvent;
import com.alicloud.openservices.tablestore.timeserieswriter.callback.TimeseriesRowResult;
import com.alicloud.openservices.tablestore.timeserieswriter.config.TimeseriesBucketConfig;
import com.alicloud.openservices.tablestore.timeserieswriter.config.TimeseriesWriterConfig;
import com.alicloud.openservices.tablestore.timeserieswriter.group.TimeseriesGroup;
import com.alicloud.openservices.tablestore.timeserieswriter.handle.TimeseriesRowEventHandler;
import com.alicloud.openservices.tablestore.timeserieswriter.handle.TimeseriesWriterHandleStatistics;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeseriesBucket {
    private Logger logger = LoggerFactory.getLogger(TimeseriesBucket.class);
    private final TimeseriesBucketConfig timeseriesBucketConfig;
    private final Disruptor<TimeseriesRowEvent> disruptor;
    private final RingBuffer<TimeseriesRowEvent> ringBuffer;
    private final TimeseriesRowEventHandler timeseriesRowEventHandler;
    private TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> resultCallback;
    private final ExecutorService disruptorExecutor;
    private final TimeseriesWriterConfig timeseriesWriterConfig;
    private final Semaphore semaphore;

    public void setResultCallback(TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> resultCallback) {
        this.resultCallback = resultCallback;
        this.timeseriesRowEventHandler.setCallback(resultCallback);
    }

    public TimeseriesBucket(TimeseriesBucketConfig timeseriesBucketConfig, AsyncTimeseriesClientInterface ots, TimeseriesWriterConfig timeseriesWriterConfig, TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> resultCallback, Executor executor, TimeseriesWriterHandleStatistics timeseriesWriterHandleStatistics, Semaphore semaphore) {
        TimeseriesRowEvent.TimeseriesRowEventFactory factory = new TimeseriesRowEvent.TimeseriesRowEventFactory();
        this.timeseriesWriterConfig = timeseriesWriterConfig;
        this.timeseriesBucketConfig = timeseriesBucketConfig;
        this.semaphore = semaphore;
        this.resultCallback = resultCallback;
        this.disruptorExecutor = Executors.newFixedThreadPool(1);
        this.disruptor = new Disruptor((EventFactory)factory, this.timeseriesWriterConfig.getBufferSize(), (Executor)this.disruptorExecutor);
        this.ringBuffer = this.disruptor.getRingBuffer();
        this.timeseriesRowEventHandler = new TimeseriesRowEventHandler(ots, timeseriesWriterConfig, timeseriesBucketConfig, this.resultCallback, executor, timeseriesWriterHandleStatistics, this.semaphore);
        this.disruptor.handleEventsWith(new EventHandler[]{this.timeseriesRowEventHandler});
        this.disruptor.start();
    }

    public boolean addRowChange(TimeseriesTableRow timeseriesTableRow, TimeseriesGroup timeseriesGroup) {
        try {
            long sequence = this.ringBuffer.tryNext();
            TimeseriesRowEvent timeseriesRowEvent = (TimeseriesRowEvent)this.ringBuffer.get(sequence);
            timeseriesRowEvent.setValue(timeseriesTableRow, timeseriesGroup);
            this.ringBuffer.publish(sequence);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    public void addSignal(CountDownLatch latch) {
        while (true) {
            try {
                long sequence = this.ringBuffer.tryNext();
                TimeseriesRowEvent timeseriesRowEvent = (TimeseriesRowEvent)this.ringBuffer.get(sequence);
                timeseriesRowEvent.setValue(latch);
                this.ringBuffer.publish(sequence);
                return;
            }
            catch (InsufficientCapacityException e) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public synchronized void close() {
        this.disruptor.shutdown();
        this.disruptorExecutor.shutdown();
    }

    public int getId() {
        return this.timeseriesBucketConfig.getBucketId();
    }

    public RingBuffer<TimeseriesRowEvent> getRingBuffer() {
        return this.ringBuffer;
    }
}

