/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.reader;

import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.Error;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.MultiRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.alicloud.openservices.tablestore.reader.PrimaryKeyWithTable;
import com.alicloud.openservices.tablestore.reader.ReaderGroup;
import com.alicloud.openservices.tablestore.reader.ReaderStatistics;
import com.alicloud.openservices.tablestore.reader.RowReadResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderCallback<Req, Res>
implements TableStoreCallback<Req, Res> {
    public static AtomicLong counter = new AtomicLong(0L);
    private final AsyncClientInterface ots;
    private final AtomicInteger count;
    private final Semaphore semaphore;
    private final Executor executor;
    private final Semaphore bucketSemaphore;
    private final ReaderStatistics statistics;
    private final Map<String, List<ReaderGroup>> groupMap;
    private final Logger logger = LoggerFactory.getLogger(ReaderCallback.class);
    private final TableStoreCallback<PrimaryKeyWithTable, RowReadResult> callback;

    public ReaderCallback(AsyncClientInterface ots, AtomicInteger count, Semaphore semaphore, TableStoreCallback<PrimaryKeyWithTable, RowReadResult> callback, Executor executor, Semaphore bucketSemaphore, ReaderStatistics statistics, Map<String, List<ReaderGroup>> groupMap) {
        this.ots = ots;
        this.count = count;
        this.semaphore = semaphore;
        this.callback = callback;
        this.executor = executor;
        this.bucketSemaphore = bucketSemaphore;
        this.statistics = statistics;
        this.groupMap = groupMap;
    }

    @Override
    public void onCompleted(Req req, Res res) {
        if (req instanceof BatchGetRowRequest) {
            PrimaryKey primaryKey;
            ReaderGroup group;
            BatchGetRowRequest request = (BatchGetRowRequest)req;
            BatchGetRowResponse result = (BatchGetRowResponse)res;
            ArrayList<BatchGetRowResponse.RowResult> succeed = new ArrayList<BatchGetRowResponse.RowResult>();
            ArrayList<BatchGetRowResponse.RowResult> failed = new ArrayList<BatchGetRowResponse.RowResult>();
            result.getResult(succeed, failed);
            for (BatchGetRowResponse.RowResult status : succeed) {
                group = this.groupMap.get(status.getTableName()).get(status.getIndex());
                primaryKey = request.getPrimaryKey(status.getTableName(), status.getIndex());
                this.triggerSucceedCallback(status, group, primaryKey);
            }
            for (BatchGetRowResponse.RowResult status : failed) {
                group = this.groupMap.get(status.getTableName()).get(status.getIndex());
                primaryKey = request.getPrimaryKey(status.getTableName(), status.getIndex());
                this.triggerFailedCallback(status, result.getRequestId(), group, primaryKey);
            }
        } else if (req instanceof GetRowRequest) {
            GetRowRequest request = (GetRowRequest)req;
            GetRowResponse result = (GetRowResponse)res;
            String tableName = request.getRowQueryCriteria().getTableName();
            BatchGetRowResponse.RowResult rowResult = new BatchGetRowResponse.RowResult(tableName, result.getRow(), result.getConsumedCapacity(), 0);
            this.triggerSucceedCallback(rowResult, this.groupMap.get(tableName).get(0), request.getRowQueryCriteria().getPrimaryKey());
        }
        this.requestComplete();
    }

    @Override
    public void onFailed(Req req, Exception ex) {
        if (ex instanceof TableStoreException) {
            this.failedOnException(req, (TableStoreException)ex);
        } else {
            this.failedOnUnknownException(req, ex);
        }
        this.requestComplete();
    }

    private void triggerSucceedCallback(final BatchGetRowResponse.RowResult rowResult, ReaderGroup group, final PrimaryKey primaryKey) {
        this.statistics.totalSucceedRowsCount.incrementAndGet();
        group.succeedOneRow(primaryKey, rowResult);
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ReaderCallback.this.callback.onCompleted(new PrimaryKeyWithTable(rowResult.getTableName(), primaryKey), new RowReadResult(primaryKey, rowResult));
            }
        });
    }

    private void triggerFailedCallback(final BatchGetRowResponse.RowResult rowResult, String requestID, ReaderGroup group, final PrimaryKey primaryKey) {
        this.statistics.totalFailedRowsCount.incrementAndGet();
        final TableStoreException exception = new TableStoreException(rowResult.getError().getMessage(), null, rowResult.getError().getCode(), requestID, 0);
        group.failedOneRow(primaryKey, rowResult, exception);
        this.logger.error("GetRow Failed, PK: {}, error: {}.", (Object)primaryKey, (Object)rowResult.getError());
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ReaderCallback.this.callback.onFailed(new PrimaryKeyWithTable(rowResult.getTableName(), primaryKey), exception);
            }
        });
    }

    public void failedOnException(Req request, TableStoreException ex) {
        this.logger.debug("OnFailed on TableStoreException:", (Throwable)ex);
        if (request instanceof BatchGetRowRequest) {
            BatchGetRowRequest batchGetRowRequest = (BatchGetRowRequest)request;
            this.retryBatchGet(batchGetRowRequest);
        } else if (request instanceof GetRowRequest) {
            String tableName = ((GetRowRequest)request).getRowQueryCriteria().getTableName();
            BatchGetRowResponse.RowResult rowResult = new BatchGetRowResponse.RowResult(tableName, new Error(ex.getErrorCode(), ex.getMessage()), 0);
            this.triggerFailedCallback(rowResult, ex.getRequestId(), this.groupMap.get(tableName).get(0), ((GetRowRequest)request).getRowQueryCriteria().getPrimaryKey());
        }
    }

    public void failedOnUnknownException(Req req, final Exception ex) {
        this.logger.debug("OnFailed on ClientException: ", (Throwable)ex);
        if (req instanceof BatchGetRowRequest) {
            final BatchGetRowRequest request = (BatchGetRowRequest)req;
            for (Map.Entry<String, MultiRowQueryCriteria> entry : request.getCriteriasByTable().entrySet()) {
                this.statistics.totalFailedRowsCount.addAndGet(entry.getValue().size());
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    PrimaryKey primaryKey = entry.getValue().get(i);
                    BatchGetRowResponse.RowResult rowResult = new BatchGetRowResponse.RowResult(entry.getKey(), new Error("FailedOnUnknownException", ex.getMessage()), i);
                    ReaderGroup group = this.groupMap.get(entry.getKey()).get(i);
                    group.failedOneRow(primaryKey, rowResult, ex);
                    this.logger.error("RowChange Failed: ", (Throwable)ex);
                }
            }
            if (this.callback == null) {
                return;
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry<String, MultiRowQueryCriteria> entry : request.getCriteriasByTable().entrySet()) {
                        for (int i = 0; i < entry.getValue().size(); ++i) {
                            PrimaryKey primaryKey = entry.getValue().get(i);
                            ReaderCallback.this.callback.onFailed(new PrimaryKeyWithTable(entry.getKey(), primaryKey), ex);
                        }
                    }
                }
            });
        } else if (req instanceof GetRowRequest) {
            String tableName = ((GetRowRequest)req).getRowQueryCriteria().getTableName();
            BatchGetRowResponse.RowResult rowResult = new BatchGetRowResponse.RowResult(tableName, new Error("FailedOnUnknownException", ex.getMessage()), 0);
            this.triggerFailedCallback(rowResult, null, this.groupMap.get(tableName).get(0), ((GetRowRequest)req).getRowQueryCriteria().getPrimaryKey());
        }
    }

    private void retryBatchGet(BatchGetRowRequest request) {
        for (Map.Entry<String, MultiRowQueryCriteria> entry : request.getCriteriasByTable().entrySet()) {
            String tableName = entry.getKey();
            for (int i = 0; i < entry.getValue().getRowKeys().size(); ++i) {
                PrimaryKey pk = entry.getValue().getRowKeys().get(i);
                SingleRowQueryCriteria singleRowCriteria = new SingleRowQueryCriteria(entry.getKey());
                entry.getValue().copyTo(singleRowCriteria);
                singleRowCriteria.setPrimaryKey(pk);
                GetRowRequest singleGetRequest = new GetRowRequest();
                singleGetRequest.setRowQueryCriteria(singleRowCriteria);
                ReaderGroup group = this.groupMap.get(tableName).get(i);
                this.retrySingleBatchGet(singleGetRequest, tableName, group);
            }
        }
    }

    private void retrySingleBatchGet(GetRowRequest singleGetRequest, String tableName, ReaderGroup group) {
        HashMap<String, List<ReaderGroup>> subGroupMap = new HashMap<String, List<ReaderGroup>>();
        ArrayList<ReaderGroup> list = new ArrayList<ReaderGroup>();
        list.add(group);
        subGroupMap.put(tableName, list);
        this.statistics.totalSingleRowRequestCount.incrementAndGet();
        this.statistics.totalRequestCount.incrementAndGet();
        this.count.incrementAndGet();
        this.ots.getRow(singleGetRequest, new ReaderCallback<GetRowRequest, GetRowResponse>(this.ots, this.count, this.semaphore, this.callback, this.executor, this.bucketSemaphore, this.statistics, subGroupMap));
    }

    private void requestComplete() {
        int remain = this.count.decrementAndGet();
        if (remain == 0) {
            this.logger.debug("BucketSemaphore Release: " + counter.incrementAndGet());
            this.semaphore.release();
            this.bucketSemaphore.release();
            this.logger.debug("Release semaphore.");
        }
    }
}

