/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.highlight;

import com.alicloud.openservices.tablestore.model.search.highlight.HighlightEncoder;
import com.alicloud.openservices.tablestore.model.search.highlight.HighlightParameter;
import java.util.HashMap;
import java.util.Map;

public class Highlight {
    private HighlightEncoder highlightEncoder = HighlightEncoder.PLAIN;
    private Map<String, HighlightParameter> fieldHighlightParams = new HashMap<String, HighlightParameter>();

    public Highlight() {
    }

    public Highlight(Map<String, HighlightParameter> fieldHighlightParams) {
        this.fieldHighlightParams = fieldHighlightParams;
    }

    public Highlight(HighlightEncoder highlightEncoder, Map<String, HighlightParameter> fieldHighlightParams) {
        this.highlightEncoder = highlightEncoder;
        this.fieldHighlightParams = fieldHighlightParams;
    }

    public Highlight(Builder builder) {
        this(builder.highlightEncoder, builder.fieldHighlightParams);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public HighlightEncoder getHighlightEncoder() {
        return this.highlightEncoder;
    }

    public Highlight setHighlightEncoder(HighlightEncoder highlightEncoder) {
        this.highlightEncoder = highlightEncoder;
        return this;
    }

    public Map<String, HighlightParameter> getFieldHighlightParams() {
        return this.fieldHighlightParams;
    }

    public Highlight setFieldHighlightParams(Map<String, HighlightParameter> fieldHighlightParams) {
        this.fieldHighlightParams = fieldHighlightParams;
        return this;
    }

    public Highlight addFieldHighlightParam(String fieldName, HighlightParameter highlightParameter) {
        this.fieldHighlightParams.put(fieldName, highlightParameter);
        return this;
    }

    public static final class Builder {
        private HighlightEncoder highlightEncoder = HighlightEncoder.PLAIN;
        private Map<String, HighlightParameter> fieldHighlightParams = new HashMap<String, HighlightParameter>();

        public Builder highlightEncoder(HighlightEncoder highlightEncoder) {
            this.highlightEncoder = highlightEncoder;
            return this;
        }

        public Builder fieldHighlightParams(Map<String, HighlightParameter> fieldHighlightParams) {
            this.fieldHighlightParams = fieldHighlightParams;
            return this;
        }

        public Builder addFieldHighlightParam(String fieldName, HighlightParameter highlightParameter) {
            this.fieldHighlightParams.put(fieldName, highlightParameter);
            return this;
        }

        public Highlight build() {
            return new Highlight(this);
        }
    }
}

