/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.reader;

import com.alicloud.openservices.tablestore.core.CallbackImpledFuture;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.reader.PrimaryKeyWithTable;
import com.alicloud.openservices.tablestore.reader.ReaderResult;
import com.alicloud.openservices.tablestore.reader.RowReadResult;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderGroup {
    private static AtomicLong idGenerator = new AtomicLong(0L);
    private final long groupId;
    private final int totalCount;
    private final AtomicInteger remainCounter;
    private final AtomicReferenceArray<RowReadResult> resultList;
    private final CallbackImpledFuture<PrimaryKeyWithTable, ReaderResult> future;
    private Logger logger = LoggerFactory.getLogger(ReaderGroup.class);

    public ReaderGroup(int totalCount) {
        this.future = new CallbackImpledFuture();
        this.totalCount = totalCount;
        this.remainCounter = new AtomicInteger(totalCount);
        this.resultList = new AtomicReferenceArray(totalCount);
        this.groupId = idGenerator.incrementAndGet();
    }

    public CallbackImpledFuture<PrimaryKeyWithTable, ReaderResult> getFuture() {
        return this.future;
    }

    public void succeedOneRow(PrimaryKey primaryKey, BatchGetRowResponse.RowResult rowResult) {
        this.finishOneRow(true, primaryKey, rowResult, null);
    }

    public void failedOneRow(PrimaryKey primaryKey, BatchGetRowResponse.RowResult rowResult, Exception exception) {
        this.finishOneRow(false, primaryKey, rowResult, exception);
    }

    private void finishOneRow(boolean isSucceed, PrimaryKey primaryKey, BatchGetRowResponse.RowResult rowResult, Exception exception) {
        int counter = this.remainCounter.decrementAndGet();
        if (counter < 0) {
            IllegalStateException exp = new IllegalStateException(String.format("[%d] ReaderResult shouldn't finish more rows than total count", this.groupId));
            this.logger.error("Group OnFinishOneRow Failed", (Throwable)exp);
            throw exp;
        }
        RowReadResult rowReadResult = new RowReadResult(primaryKey, rowResult);
        this.resultList.set(this.totalCount - counter - 1, rowReadResult);
        if (counter == 0) {
            this.completeGroup();
        }
    }

    private void completeGroup() {
        ReaderResult readerResult = new ReaderResult(this.totalCount, this.resultList);
        this.future.onCompleted(null, readerResult);
    }

    public long getGroupId() {
        return this.groupId;
    }
}

