/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

import com.alicloud.openservices.tablestore.core.protocol.SearchQueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.QueryType;
import com.google.protobuf.ByteString;

public class SuffixQuery
implements Query {
    private final QueryType queryType = QueryType.QueryType_SuffixQuery;
    public String fieldName;
    private String suffix;
    private float weight = 1.0f;

    @Override
    public QueryType getQueryType() {
        return this.queryType;
    }

    @Override
    public ByteString serialize() {
        return SearchQueryBuilder.buildSuffixQuery(this).toByteString();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    protected static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements QueryBuilder {
        private String fieldName;
        private String suffix;
        private float weight = 1.0f;

        public Builder weight(float weight) {
            this.weight = weight;
            return this;
        }

        private Builder() {
        }

        public Builder field(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        @Override
        public SuffixQuery build() {
            SuffixQuery suffixQuery = new SuffixQuery();
            suffixQuery.setFieldName(this.fieldName);
            suffixQuery.setSuffix(this.suffix);
            suffixQuery.setWeight(this.weight);
            return suffixQuery;
        }
    }
}

