/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

import com.alicloud.openservices.tablestore.core.protocol.SearchQueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.QueryType;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;

public class GeoPolygonQuery
implements Query {
    private final QueryType queryType = QueryType.QueryType_GeoPolygonQuery;
    private String fieldName;
    private List<String> points;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public List<String> getPoints() {
        return this.points;
    }

    public void setPoints(List<String> points) {
        this.points = points;
    }

    @Override
    public QueryType getQueryType() {
        return this.queryType;
    }

    @Override
    public ByteString serialize() {
        return SearchQueryBuilder.buildGeoPolygonQuery(this).toByteString();
    }

    protected static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements QueryBuilder {
        private String fieldName;
        private List<String> points;

        private Builder() {
        }

        public Builder field(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder addPoint(String pointString) {
            if (this.points == null) {
                this.points = new ArrayList<String>();
            }
            this.points.add(pointString);
            return this;
        }

        @Override
        public GeoPolygonQuery build() {
            GeoPolygonQuery geoPolygonQuery = new GeoPolygonQuery();
            geoPolygonQuery.setFieldName(this.fieldName);
            geoPolygonQuery.setPoints(this.points);
            return geoPolygonQuery;
        }
    }
}

