/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.condition;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.protocol.OTSProtocolBuilder;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.condition.ColumnCondition;
import com.alicloud.openservices.tablestore.model.condition.ColumnConditionType;
import com.alicloud.openservices.tablestore.model.condition.SingleColumnValueCondition;
import com.alicloud.openservices.tablestore.model.filter.CompositeColumnValueFilter;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;

public class CompositeColumnValueCondition
implements ColumnCondition {
    private LogicOperator type;
    private List<ColumnCondition> conditions;

    public CompositeColumnValueCondition(LogicOperator loType) {
        Preconditions.checkNotNull(loType, "The operation type should not be null.");
        this.type = loType;
        this.conditions = new ArrayList<ColumnCondition>();
    }

    public CompositeColumnValueCondition addCondition(ColumnCondition condition) {
        Preconditions.checkNotNull(condition, "The condition should not be null.");
        this.conditions.add(condition);
        return this;
    }

    public void clear() {
        this.conditions.clear();
    }

    public LogicOperator getOperationType() {
        return this.type;
    }

    public List<ColumnCondition> getSubConditions() {
        return this.conditions;
    }

    @Override
    public ColumnConditionType getConditionType() {
        return ColumnConditionType.COMPOSITE_COLUMN_VALUE_CONDITION;
    }

    public CompositeColumnValueFilter toFilter() {
        CompositeColumnValueFilter.LogicOperator logicOperator;
        switch (this.type) {
            case NOT: {
                logicOperator = CompositeColumnValueFilter.LogicOperator.NOT;
                break;
            }
            case AND: {
                logicOperator = CompositeColumnValueFilter.LogicOperator.AND;
                break;
            }
            case OR: {
                logicOperator = CompositeColumnValueFilter.LogicOperator.OR;
                break;
            }
            default: {
                throw new ClientException("Unknown logicOperator: " + this.type.name());
            }
        }
        CompositeColumnValueFilter compositeColumnValueFilter = new CompositeColumnValueFilter(logicOperator);
        for (ColumnCondition condition : this.getSubConditions()) {
            if (condition instanceof SingleColumnValueCondition) {
                compositeColumnValueFilter.addFilter(((SingleColumnValueCondition)condition).toFilter());
                continue;
            }
            if (condition instanceof CompositeColumnValueCondition) {
                compositeColumnValueFilter.addFilter(((CompositeColumnValueCondition)condition).toFilter());
                continue;
            }
            throw new ClientException("Unknown condition type: " + (Object)((Object)condition.getConditionType()));
        }
        return compositeColumnValueFilter;
    }

    @Override
    public ByteString serialize() {
        return OTSProtocolBuilder.buildCompositeColumnValueFilter(this.toFilter());
    }

    public static enum LogicOperator {
        NOT,
        AND,
        OR;

    }
}

