/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCodedInputStream;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferConversion;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferInputStream;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferRow;
import com.alicloud.openservices.tablestore.core.protocol.ResponseFactory;
import com.alicloud.openservices.tablestore.model.Row;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainBufferBlockParser {
    private static Logger logger = LoggerFactory.getLogger(ResponseFactory.class);
    private ByteBuffer buffer;
    private List<Row> rows;

    public PlainBufferBlockParser(ByteBuffer buffer) {
        this.buffer = buffer;
        this.rows = new ArrayList<Row>();
        try {
            if (buffer != null) {
                PlainBufferCodedInputStream inputStream = new PlainBufferCodedInputStream(new PlainBufferInputStream(buffer));
                List<PlainBufferRow> pbRows = inputStream.readRowsWithHeader();
                for (PlainBufferRow pbRow : pbRows) {
                    this.rows.add(PlainBufferConversion.toRow(pbRow));
                }
            }
        }
        catch (Exception e) {
            throw new ClientException("Failed to parse get range response.", e);
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public int getTotalBytes() {
        return this.buffer.limit();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PlainBufferBlock{\n");
        for (Row row : this.rows) {
            sb.append(row).append('\n');
        }
        sb.append("}");
        return sb.toString();
    }
}

