/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.PartialResultFailedException;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.OperationNames;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class CustomRetryStrategy
implements RetryStrategy {
    private final int MAX_BASE = 2000;
    private final Random rnd = new Random();
    private volatile int base = 100;
    private volatile int retries = 0;
    private volatile long timeout = 0L;
    private volatile long deadline = 0L;
    private final boolean retryUnIdempotentWriteOperation;

    public CustomRetryStrategy() {
        this(10L, TimeUnit.SECONDS);
    }

    public CustomRetryStrategy(long timeout, TimeUnit unit) {
        this(timeout, unit, false);
    }

    public CustomRetryStrategy(long timeout, TimeUnit unit, boolean retryUnIdempotentWriteOperation) {
        this.timeout = unit.toMillis(timeout);
        this.deadline = System.currentTimeMillis() + this.timeout;
        this.retryUnIdempotentWriteOperation = retryUnIdempotentWriteOperation;
    }

    @Override
    public RetryStrategy clone() {
        return new CustomRetryStrategy(this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    private boolean retryNotMatterActions(String errorCode, String errorMessage) {
        return errorCode.equals("OTSRowOperationConflict") || errorCode.equals("OTSNotEnoughCapacityUnit") || errorCode.equals("OTSTableNotReady") || errorCode.equals("OTSPartitionUnavailable") || errorCode.equals("OTSServerBusy") || errorCode.equals("OTSQuotaExhausted") && errorMessage.equals("Too frequent table operations.");
    }

    private boolean shouldRetryWithOTSException(String action, boolean isIdempotent, String errorCode, String errorMessage, int httpStatus) {
        boolean serverError;
        if (this.retryNotMatterActions(errorCode, errorMessage)) {
            return true;
        }
        boolean bl = serverError = httpStatus >= 500 && httpStatus <= 599 || errorCode.equals("OTSTimeout") || errorCode.equals("OTSInternalServerError") || errorCode.equals("OTSServerUnavailable") || errorCode.equals("OTSTunnelServerUnavailable");
        if (serverError && isIdempotent) {
            return true;
        }
        return serverError && this.retryUnIdempotentWriteOperation && ("UpdateRow".equals(action) || "PutRow".equals(action) || "BatchWriteRow".equals(action));
    }

    public boolean shouldRetry(String action, Exception ex) {
        boolean isIdempotent = OperationNames.IdempotentActionTool.isIdempotentAction(action);
        if (ex instanceof TableStoreException) {
            if (ex instanceof PartialResultFailedException) {
                PartialResultFailedException prfe = (PartialResultFailedException)ex;
                for (TableStoreException otsException : prfe.getErrors()) {
                    if (this.shouldRetryWithOTSException(action, isIdempotent, otsException.getErrorCode(), otsException.getMessage(), prfe.getHttpStatus())) continue;
                    return false;
                }
                return true;
            }
            TableStoreException otsException = (TableStoreException)ex;
            return this.shouldRetryWithOTSException(action, isIdempotent, otsException.getErrorCode(), otsException.getMessage(), otsException.getHttpStatus());
        }
        if (ex instanceof ClientException) {
            return isIdempotent;
        }
        return false;
    }

    @Override
    public long nextPause(String action, Exception ex) {
        if (!this.shouldRetry(action, ex)) {
            return 0L;
        }
        if (this.base <= 0) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        int expire = (int)(this.deadline - now);
        if (expire <= 0) {
            return 0L;
        }
        long delay = Math.min(this.base / 2 + this.rnd.nextInt(this.base), expire);
        ++this.retries;
        this.base *= 2;
        if (this.base > 2000) {
            this.base = 2000;
        }
        return delay;
    }
}

