/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.PartialResultFailedException;
import com.alicloud.openservices.tablestore.core.OperationLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProvider;
import com.alicloud.openservices.tablestore.core.http.AsyncServiceClient;
import com.alicloud.openservices.tablestore.core.http.OTSUri;
import com.alicloud.openservices.tablestore.core.http.PutTimeseriesDataResponseConsumer;
import com.alicloud.openservices.tablestore.core.protocol.ResultParserFactory;
import com.alicloud.openservices.tablestore.core.protocol.timeseries.Timeseries;
import com.alicloud.openservices.tablestore.core.protocol.timeseries.TimeseriesProtocolBuilder;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataRequest;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataResponse;
import com.google.common.cache.Cache;
import com.google.protobuf.Message;
import org.apache.http.concurrent.FutureCallback;

public class PutTimeseriesDataLauncher
extends OperationLauncher<PutTimeseriesDataRequest, PutTimeseriesDataResponse> {
    private OTSUri uri;
    private TraceLogger tracer;
    private RetryStrategy retry;
    private Cache<String, Long> timeseriesMetaCache;

    public PutTimeseriesDataLauncher(OTSUri uri, TraceLogger tracer, RetryStrategy retry, String instanceName, AsyncServiceClient client, CredentialsProvider crdsProvider, ClientConfiguration config, PutTimeseriesDataRequest originRequest, Cache<String, Long> timeseriesMetaCache) {
        super(instanceName, client, crdsProvider, config, originRequest);
        Preconditions.checkNotNull(uri);
        Preconditions.checkNotNull(tracer);
        Preconditions.checkNotNull(retry);
        Preconditions.checkNotNull(timeseriesMetaCache);
        this.uri = uri;
        this.tracer = tracer;
        this.retry = retry;
        this.timeseriesMetaCache = timeseriesMetaCache;
    }

    @Override
    public PutTimeseriesDataRequest getRequestForRetry(Exception e) {
        PutTimeseriesDataRequest request = (PutTimeseriesDataRequest)this.originRequest;
        if (e instanceof PartialResultFailedException) {
            this.lastResult = (PutTimeseriesDataResponse)((PartialResultFailedException)e).getResult();
            request = ((PutTimeseriesDataRequest)this.originRequest).createRequestForRetry(((PutTimeseriesDataResponse)this.lastResult).getFailedRows());
        }
        return request;
    }

    @Override
    public void fire(PutTimeseriesDataRequest request, FutureCallback<PutTimeseriesDataResponse> cb) {
        LogUtil.logBeforeExecution(this.tracer, this.retry);
        Timeseries.PutTimeseriesDataResponse defaultResponse = Timeseries.PutTimeseriesDataResponse.getDefaultInstance();
        this.asyncInvokePost(this.uri, null, (Message)TimeseriesProtocolBuilder.buildPutTimeseriesDataRequest(request, this.timeseriesMetaCache), this.tracer, new PutTimeseriesDataResponseConsumer(ResultParserFactory.createFactory().createProtocolBufferResultParser((Message)defaultResponse, this.tracer.getTraceId()), this.tracer, this.retry, (PutTimeseriesDataResponse)this.lastResult, request, this.timeseriesMetaCache), cb);
    }
}

