/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.anno.SerialPolicy;
import com.alicp.jetcache.anno.support.DefaultEncoderParser;
import com.alicp.jetcache.support.JavaValueDecoder;
import com.alicp.jetcache.support.SpringJavaValueDecoder;
import java.util.function.Function;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultSpringEncoderParser
extends DefaultEncoderParser
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    static String parseBeanName(String str) {
        String beanPrefix = "bean:";
        int len = "bean:".length();
        if (str != null && str.startsWith("bean:") && str.length() > len) {
            return str.substring(len);
        }
        return null;
    }

    @Override
    public Function<Object, byte[]> parseEncoder(String valueEncoder) {
        String beanName = DefaultSpringEncoderParser.parseBeanName(valueEncoder);
        if (beanName == null) {
            return super.parseEncoder(valueEncoder);
        }
        Object bean = this.applicationContext.getBean(beanName);
        if (bean instanceof Function) {
            return (Function)bean;
        }
        return ((SerialPolicy)bean).encoder();
    }

    @Override
    public Function<byte[], Object> parseDecoder(String valueDecoder) {
        String beanName = DefaultSpringEncoderParser.parseBeanName(valueDecoder);
        if (beanName == null) {
            return super.parseDecoder(valueDecoder);
        }
        Object bean = this.applicationContext.getBean(beanName);
        if (bean instanceof Function) {
            return (Function)bean;
        }
        return ((SerialPolicy)bean).decoder();
    }

    @Override
    JavaValueDecoder javaValueDecoder(boolean useIdentityNumber) {
        return new SpringJavaValueDecoder(useIdentityNumber);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

