/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.aop;

import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.anno.aop.CachePointcut;
import com.alicp.jetcache.anno.method.CacheHandler;
import com.alicp.jetcache.anno.method.CacheInvokeConfig;
import com.alicp.jetcache.anno.method.CacheInvokeContext;
import com.alicp.jetcache.anno.support.ConfigMap;
import com.alicp.jetcache.anno.support.ConfigProvider;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class JetCacheInterceptor
implements MethodInterceptor,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(JetCacheInterceptor.class);
    @Autowired
    private ConfigMap cacheConfigMap;
    private ApplicationContext applicationContext;
    private GlobalCacheConfig globalCacheConfig;
    ConfigProvider configProvider;
    CacheManager cacheManager;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.configProvider == null) {
            this.configProvider = (ConfigProvider)((Object)this.applicationContext.getBean(ConfigProvider.class));
        }
        if (this.configProvider != null && this.globalCacheConfig == null) {
            this.globalCacheConfig = this.configProvider.getGlobalCacheConfig();
        }
        if (this.globalCacheConfig == null || !this.globalCacheConfig.isEnableMethodCache()) {
            return invocation.proceed();
        }
        if (this.cacheManager == null) {
            this.cacheManager = (CacheManager)this.applicationContext.getBean(CacheManager.class);
            if (this.cacheManager == null) {
                logger.error("There is no cache manager instance in spring context");
                return invocation.proceed();
            }
        }
        Method method = invocation.getMethod();
        Object obj = invocation.getThis();
        CacheInvokeConfig cac = null;
        if (obj != null) {
            String key = CachePointcut.getKey(method, obj.getClass());
            cac = this.cacheConfigMap.getByMethodInfo(key);
        }
        if (cac == null || cac == CacheInvokeConfig.getNoCacheInvokeConfigInstance()) {
            return invocation.proceed();
        }
        CacheInvokeContext context = this.configProvider.newContext(this.cacheManager).createCacheInvokeContext(this.cacheConfigMap);
        context.setTargetObject(invocation.getThis());
        context.setInvoker(() -> ((MethodInvocation)invocation).proceed());
        context.setMethod(method);
        context.setArgs(invocation.getArguments());
        context.setCacheInvokeConfig(cac);
        context.setHiddenPackages(this.globalCacheConfig.getHiddenPackages());
        return CacheHandler.invoke(context);
    }

    public void setCacheConfigMap(ConfigMap cacheConfigMap) {
        this.cacheConfigMap = cacheConfigMap;
    }
}

