/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.labels.impl;

import com.alibaba.nacos.common.labels.LabelsCollector;
import com.alibaba.nacos.common.utils.ConnLabelsUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLabelsCollector
implements LabelsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"com.alibaba.nacos.common.labels");
    private final String customName = "defaultNacosLabelsCollector";
    private static final String UNDERSCORE = "_";
    private static final String ESCAPE = "\\";
    private static final int DEFAULT_INITIAL_ORDER = 100;

    @Override
    public Map<String, String> collectLabels(Properties properties) {
        LOGGER.info("default nacos collect properties raw labels: {}", (Object)properties.getProperty("nacos.app.conn.labels"));
        Map<String, String> propertiesLabels = ConnLabelsUtils.parseRawLabels(properties.getProperty("nacos.app.conn.labels"));
        if (properties.containsKey("nacos.config.gray.label")) {
            propertiesLabels.put("nacos.config.gray.label", properties.getProperty("nacos.config.gray.label"));
        }
        LOGGER.info("default nacos collect properties labels: {}", propertiesLabels);
        LOGGER.info("default nacos collect jvm raw labels: {}", (Object)System.getProperty("nacos.app.conn.labels"));
        Map<String, String> jvmLabels = ConnLabelsUtils.parseRawLabels(System.getProperty("nacos.app.conn.labels"));
        if (System.getProperty("nacos.config.gray.label") != null) {
            jvmLabels.put("nacos.config.gray.label", System.getProperty("nacos.config.gray.label"));
        }
        LOGGER.info("default nacos collect jvm labels: {}", jvmLabels);
        LOGGER.info("default nacos collect env raw labels: {}", (Object)System.getenv("nacos.app.conn.labels".replaceAll("\\.", UNDERSCORE)));
        Map<String, String> envLabels = ConnLabelsUtils.parseRawLabels(System.getenv("nacos.app.conn.labels".replaceAll("\\.", UNDERSCORE)));
        if (System.getenv("nacos.config.gray.label".replaceAll("\\.", UNDERSCORE)) != null) {
            envLabels.put("nacos.config.gray.label", System.getenv("nacos.config.gray.label".replaceAll("\\.", UNDERSCORE)));
        }
        LOGGER.info("default nacos collect env labels: {}", envLabels);
        Map<Object, Object> finalLabels = new HashMap(4);
        String preferred = System.getenv("nacos_app_conn_labels_preferred");
        boolean jvmPrefferred = false;
        boolean envPrefferred = false;
        if (StringUtils.isNotBlank(preferred)) {
            LOGGER.info("default nacos  labels collector preferred {} labels.", (Object)preferred);
            if ("jvm".equals(preferred)) {
                finalLabels.putAll(jvmLabels);
                jvmPrefferred = true;
            } else if ("env".equals(preferred)) {
                finalLabels.putAll(envLabels);
                envPrefferred = true;
            }
        }
        finalLabels = ConnLabelsUtils.mergeMapByOrder(finalLabels, propertiesLabels);
        if (!jvmPrefferred) {
            finalLabels = ConnLabelsUtils.mergeMapByOrder(finalLabels, jvmLabels);
        }
        if (!envPrefferred) {
            finalLabels = ConnLabelsUtils.mergeMapByOrder(finalLabels, envLabels);
        }
        for (Map.Entry<Object, Object> entry : finalLabels.entrySet()) {
            LOGGER.info("default nacos init labels: {}={}", entry.getKey(), entry.getValue());
        }
        return finalLabels;
    }

    @Override
    public String getName() {
        return "defaultNacosLabelsCollector";
    }

    @Override
    public int getOrder() {
        return 100;
    }
}

