/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.pojo.healthcheck;

import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckerFactory;
import com.alibaba.nacos.api.naming.pojo.healthcheck.impl.Http;
import com.alibaba.nacos.api.naming.pojo.healthcheck.impl.Mysql;
import com.alibaba.nacos.api.naming.pojo.healthcheck.impl.Tcp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum HealthCheckType {
    TCP(Tcp.class),
    HTTP(Http.class),
    MYSQL(Mysql.class),
    NONE(AbstractHealthChecker.None.class);

    private final Class<? extends AbstractHealthChecker> healthCheckerClass;
    private static final Map<String, Class<? extends AbstractHealthChecker>> EXTEND;

    private HealthCheckType(Class<? extends AbstractHealthChecker> healthCheckerClass) {
        this.healthCheckerClass = healthCheckerClass;
    }

    public static void registerHealthChecker(String type, Class<? extends AbstractHealthChecker> healthCheckerClass) {
        if (!EXTEND.containsKey(type)) {
            EXTEND.put(type, healthCheckerClass);
            HealthCheckerFactory.registerSubType(healthCheckerClass, type);
        }
    }

    public static Class<? extends AbstractHealthChecker> ofHealthCheckerClass(String type) {
        HealthCheckType enumType;
        try {
            enumType = HealthCheckType.valueOf(type);
        }
        catch (Exception e) {
            return EXTEND.get(type);
        }
        return enumType.healthCheckerClass;
    }

    public static List<Class<? extends AbstractHealthChecker>> getLoadedHealthCheckerClasses() {
        ArrayList<Class<? extends AbstractHealthChecker>> all = new ArrayList<Class<? extends AbstractHealthChecker>>();
        for (HealthCheckType type : HealthCheckType.values()) {
            all.add(type.healthCheckerClass);
        }
        for (Map.Entry entry : EXTEND.entrySet()) {
            all.add((Class<? extends AbstractHealthChecker>)entry.getValue());
        }
        return all;
    }

    static {
        EXTEND = new ConcurrentHashMap<String, Class<? extends AbstractHealthChecker>>();
    }
}

