/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.exception.runtime;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;

public class NacosSerializationException
extends NacosRuntimeException {
    private static final long serialVersionUID = -4308536346316915612L;
    private static final String DEFAULT_MSG = "Nacos serialize failed. ";
    private static final String MSG_FOR_SPECIFIED_CLASS = "Nacos serialize for class [%s] failed. ";
    private Class<?> serializedClass;

    public NacosSerializationException() {
        super(100);
    }

    public NacosSerializationException(Class<?> serializedClass) {
        super(100, String.format(MSG_FOR_SPECIFIED_CLASS, serializedClass.getName()));
        this.serializedClass = serializedClass;
    }

    public NacosSerializationException(Throwable throwable) {
        super(100, DEFAULT_MSG, throwable);
    }

    public NacosSerializationException(Class<?> serializedClass, Throwable throwable) {
        super(100, String.format(MSG_FOR_SPECIFIED_CLASS, serializedClass.getName()), throwable);
        this.serializedClass = serializedClass;
    }

    public Class<?> getSerializedClass() {
        return this.serializedClass;
    }
}

