/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.shaded.io.opencensus.metrics;

import com.alibaba.nacos.shaded.io.opencensus.common.ToDoubleFunction;
import com.alibaba.nacos.shaded.io.opencensus.internal.Utils;
import com.alibaba.nacos.shaded.io.opencensus.metrics.LabelKey;
import com.alibaba.nacos.shaded.io.opencensus.metrics.LabelValue;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class DerivedDoubleCumulative {
    public abstract <T> void createTimeSeries(List<LabelValue> var1, T var2, ToDoubleFunction<T> var3);

    public abstract void removeTimeSeries(List<LabelValue> var1);

    public abstract void clear();

    static DerivedDoubleCumulative newNoopDerivedDoubleCumulative(String name, String description, String unit, List<LabelKey> labelKeys) {
        return NoopDerivedDoubleCumulative.create(name, description, unit, labelKeys);
    }

    private static final class NoopDerivedDoubleCumulative
    extends DerivedDoubleCumulative {
        private final int labelKeysSize;

        static NoopDerivedDoubleCumulative create(String name, String description, String unit, List<LabelKey> labelKeys) {
            return new NoopDerivedDoubleCumulative(name, description, unit, labelKeys);
        }

        NoopDerivedDoubleCumulative(String name, String description, String unit, List<LabelKey> labelKeys) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(description, "description");
            Utils.checkNotNull(unit, "unit");
            Utils.checkListElementNotNull(Utils.checkNotNull(labelKeys, "labelKeys"), "labelKey");
            this.labelKeysSize = labelKeys.size();
        }

        @Override
        public <T> void createTimeSeries(List<LabelValue> labelValues, T obj, ToDoubleFunction<T> function) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelValues, "labelValues"), "labelValue");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            Utils.checkNotNull(function, "function");
        }

        @Override
        public void removeTimeSeries(List<LabelValue> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        @Override
        public void clear() {
        }
    }
}

