/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client.request;

import com.alibaba.nacos.common.http.BaseHttpMethod;
import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.client.request.HttpClientRequest;
import com.alibaba.nacos.common.http.client.response.DefaultClientHttpResponse;
import com.alibaba.nacos.common.http.client.response.HttpClientResponse;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.model.RequestHttpEntity;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class DefaultHttpClientRequest
implements HttpClientRequest {
    private final CloseableHttpClient client;

    public DefaultHttpClientRequest(CloseableHttpClient client) {
        this.client = client;
    }

    @Override
    public HttpClientResponse execute(URI uri, String httpMethod, RequestHttpEntity requestHttpEntity) throws Exception {
        HttpRequestBase request = DefaultHttpClientRequest.build(uri, httpMethod, requestHttpEntity);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
        return new DefaultClientHttpResponse((HttpResponse)response);
    }

    static HttpRequestBase build(URI uri, String method, RequestHttpEntity requestHttpEntity) throws Exception {
        Header headers = requestHttpEntity.getHeaders();
        BaseHttpMethod httpMethod = BaseHttpMethod.sourceOf(method);
        HttpRequestBase httpRequestBase = httpMethod.init(uri.toString());
        HttpUtils.initRequestHeader(httpRequestBase, headers);
        if ("application/x-www-form-urlencoded;charset=UTF-8".equals(headers.getValue("Content-Type")) && requestHttpEntity.getBody() instanceof Map) {
            HttpUtils.initRequestFromEntity(httpRequestBase, (Map)requestHttpEntity.getBody(), headers.getCharset());
        } else {
            HttpUtils.initRequestEntity(httpRequestBase, requestHttpEntity.getBody(), headers);
        }
        DefaultHttpClientRequest.replaceDefaultConfig(httpRequestBase, requestHttpEntity.getHttpClientConfig());
        return httpRequestBase;
    }

    private static void replaceDefaultConfig(HttpRequestBase requestBase, HttpClientConfig httpClientConfig) {
        if (httpClientConfig == null) {
            return;
        }
        requestBase.setConfig(RequestConfig.custom().setConnectTimeout(httpClientConfig.getConTimeOutMillis()).setSocketTimeout(httpClientConfig.getReadTimeOutMillis()).build());
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

