/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsLateralViewTableSource;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsValuesTableSource;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;

public class OdpsSelectParser
extends SQLSelectParser {
    public OdpsSelectParser(SQLExprParser exprParser) {
        super(exprParser.getLexer());
        this.exprParser = exprParser;
    }

    @Override
    public SQLSelectQuery query() {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            return this.queryRest(select);
        }
        OdpsSelectQueryBlock queryBlock = new OdpsSelectQueryBlock();
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            queryBlock.addBeforeComment(this.lexer.readAndResetComments());
        }
        this.accept(Token.SELECT);
        if (this.lexer.token() == Token.HINT) {
            this.exprParser.parseHints(queryBlock.getHints());
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.DISTINCT) {
            queryBlock.setDistionOption(2);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.UNIQUE) {
            queryBlock.setDistionOption(3);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.ALL) {
            queryBlock.setDistionOption(1);
            this.lexer.nextToken();
        }
        this.parseSelectList(queryBlock);
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        queryBlock.setOrderBy(this.exprParser.parseOrderBy());
        if (this.lexer.token() == Token.DISTRIBUTE) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.exprParser.exprList(queryBlock.getDistributeBy(), queryBlock);
            if (this.identifierEquals("SORT")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                while (true) {
                    SQLExpr expr = this.expr();
                    SQLSelectOrderByItem sortByItem = new SQLSelectOrderByItem(expr);
                    if (this.lexer.token() == Token.ASC) {
                        sortByItem.setType(SQLOrderingSpecification.ASC);
                        this.lexer.nextToken();
                    } else if (this.lexer.token() == Token.DESC) {
                        sortByItem.setType(SQLOrderingSpecification.DESC);
                        this.lexer.nextToken();
                    }
                    queryBlock.getSortBy().add(sortByItem);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
        }
        if (this.lexer.token() == Token.LIMIT) {
            this.lexer.nextToken();
            queryBlock.setLimit(new SQLLimit(this.expr()));
        }
        return this.queryRest(queryBlock);
    }

    @Override
    public SQLTableSource parseTableSource() {
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            OdpsValuesTableSource tableSource = new OdpsValuesTableSource();
            while (true) {
                this.accept(Token.LPAREN);
                SQLListExpr listExpr = new SQLListExpr();
                this.exprParser.exprList(listExpr.getItems(), listExpr);
                this.accept(Token.RPAREN);
                listExpr.setParent(tableSource);
                tableSource.getValues().add(listExpr);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            String alias = this.as();
            tableSource.setAlias(alias);
            this.accept(Token.LPAREN);
            this.exprParser.names(tableSource.getColumns(), tableSource);
            this.accept(Token.RPAREN);
            return tableSource;
        }
        return super.parseTableSource();
    }

    @Override
    protected SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
        if ("LATERAL".equalsIgnoreCase((tableSource = super.parseTableSourceRest(tableSource)).getAlias()) && this.lexer.token() == Token.VIEW) {
            return this.parseLateralView(tableSource);
        }
        if (this.identifierEquals("LATERAL")) {
            this.lexer.nextToken();
            return this.parseLateralView(tableSource);
        }
        return tableSource;
    }

    protected SQLTableSource parseLateralView(SQLTableSource tableSource) {
        this.accept(Token.VIEW);
        tableSource.setAlias(null);
        OdpsLateralViewTableSource lateralViewTabSrc = new OdpsLateralViewTableSource();
        lateralViewTabSrc.setTableSource(tableSource);
        SQLMethodInvokeExpr udtf = (SQLMethodInvokeExpr)this.exprParser.expr();
        lateralViewTabSrc.setMethod(udtf);
        String alias = this.as();
        lateralViewTabSrc.setAlias(alias);
        this.accept(Token.AS);
        this.exprParser.names(lateralViewTabSrc.getColumns());
        return this.parseTableSourceRest(lateralViewTabSrc);
    }
}

