/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dcm.internal;

import com.alibaba.dcm.DnsCache;
import com.alibaba.dcm.DnsCacheEntry;
import com.alibaba.dcm.internal.InetAddressCacheUtilCommons;
import com.alibaba.dcm.internal.TimeUtil;
import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jetbrains.annotations.ApiStatus;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@ApiStatus.Internal
public final class InetAddressCacheUtilForNew {
    private static volatile Constructor<?> constructorOfInetAddress$CachedAddresses = null;
    private static volatile Field hostFieldOfInetAddress$CacheAddress = null;
    private static volatile Object[] ADDRESS_CACHE_AND_EXPIRY_SET = null;
    private static final String inetAddress$CachedAddresses_ClassName = "java.net.InetAddress$CachedAddresses";
    private static final String inetAddress$NameServiceAddresses_ClassName = "java.net.InetAddress$NameServiceAddresses";
    private static volatile Field inetAddressesFieldOfInetAddress$CacheAddress = null;
    private static volatile Field expiryTimeFieldOfInetAddress$CacheAddress = null;

    public static void setInetAddressCache(String host, String[] ips, long expireMillis) throws UnknownHostException, IllegalAccessException, InstantiationException, InvocationTargetException, ClassNotFoundException, NoSuchFieldException {
        long expiration = expireMillis == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUtil.getNanoTimeAfterMs(expireMillis);
        Object cachedAddresses = InetAddressCacheUtilForNew.newCachedAddresses(host, ips, expiration);
        InetAddressCacheUtilForNew.getCacheOfInetAddress().put(host, cachedAddresses);
        InetAddressCacheUtilForNew.getExpirySetOfInetAddress().add(cachedAddresses);
    }

    private static Object newCachedAddresses(String host, String[] ips, long expiration) throws ClassNotFoundException, UnknownHostException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return InetAddressCacheUtilForNew.getConstructorOfInetAddress$CachedAddresses().newInstance(host, InetAddressCacheUtilCommons.toInetAddressArray(host, ips), expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Constructor<?> getConstructorOfInetAddress$CachedAddresses() throws ClassNotFoundException {
        if (constructorOfInetAddress$CachedAddresses != null) {
            return constructorOfInetAddress$CachedAddresses;
        }
        Class<InetAddressCacheUtilCommons> clazz = InetAddressCacheUtilCommons.class;
        synchronized (InetAddressCacheUtilCommons.class) {
            if (constructorOfInetAddress$CachedAddresses != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return constructorOfInetAddress$CachedAddresses;
            }
            Class<?> clazz2 = Class.forName(inetAddress$CachedAddresses_ClassName);
            Constructor<?> constructor = clazz2.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            constructorOfInetAddress$CachedAddresses = constructor;
            // ** MonitorExit[var0] (shouldn't be in output)
            return constructor;
        }
    }

    public static void removeInetAddressCache(String host) throws NoSuchFieldException, IllegalAccessException {
        InetAddressCacheUtilForNew.removeHostFromExpirySetOfInetAddress(host);
        InetAddressCacheUtilForNew.getCacheOfInetAddress().remove(host);
    }

    private static void removeHostFromExpirySetOfInetAddress(String host) throws NoSuchFieldException, IllegalAccessException {
        Iterator<Object> iterator = InetAddressCacheUtilForNew.getExpirySetOfInetAddress().iterator();
        while (iterator.hasNext()) {
            Object cachedAddresses = iterator.next();
            if (!InetAddressCacheUtilForNew.getHostOfInetAddress$CacheAddress(cachedAddresses).equals(host)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getHostOfInetAddress$CacheAddress(Object cachedAddresses) throws NoSuchFieldException, IllegalAccessException {
        if (hostFieldOfInetAddress$CacheAddress != null) return (String)hostFieldOfInetAddress$CacheAddress.get(cachedAddresses);
        Class<InetAddressCacheUtilForNew> clazz = InetAddressCacheUtilForNew.class;
        synchronized (InetAddressCacheUtilForNew.class) {
            if (hostFieldOfInetAddress$CacheAddress != null) return (String)hostFieldOfInetAddress$CacheAddress.get(cachedAddresses);
            Field f = cachedAddresses.getClass().getDeclaredField("host");
            f.setAccessible(true);
            hostFieldOfInetAddress$CacheAddress = f;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (String)hostFieldOfInetAddress$CacheAddress.get(cachedAddresses);
        }
    }

    private static ConcurrentMap<String, Object> getCacheOfInetAddress() throws NoSuchFieldException, IllegalAccessException {
        return (ConcurrentMap)InetAddressCacheUtilForNew.getCacheAndExpirySetOfInetAddress0()[0];
    }

    private static ConcurrentSkipListSet<Object> getExpirySetOfInetAddress() throws NoSuchFieldException, IllegalAccessException {
        return (ConcurrentSkipListSet)InetAddressCacheUtilForNew.getCacheAndExpirySetOfInetAddress0()[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] getCacheAndExpirySetOfInetAddress0() throws NoSuchFieldException, IllegalAccessException {
        if (ADDRESS_CACHE_AND_EXPIRY_SET != null) {
            return ADDRESS_CACHE_AND_EXPIRY_SET;
        }
        Class<InetAddressCacheUtilForNew> clazz = InetAddressCacheUtilForNew.class;
        synchronized (InetAddressCacheUtilForNew.class) {
            if (ADDRESS_CACHE_AND_EXPIRY_SET != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return ADDRESS_CACHE_AND_EXPIRY_SET;
            }
            Field cacheField = InetAddress.class.getDeclaredField("cache");
            cacheField.setAccessible(true);
            Field expirySetField = InetAddress.class.getDeclaredField("expirySet");
            expirySetField.setAccessible(true);
            ADDRESS_CACHE_AND_EXPIRY_SET = new Object[]{cacheField.get(InetAddress.class), expirySetField.get(InetAddress.class)};
            // ** MonitorExit[var0] (shouldn't be in output)
            return ADDRESS_CACHE_AND_EXPIRY_SET;
        }
    }

    @Nullable
    public static DnsCacheEntry getInetAddressCache(String host) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        Object addresses = InetAddressCacheUtilForNew.getCacheOfInetAddress().get(host);
        if (null == addresses) {
            return null;
        }
        return InetAddressCacheUtilForNew.inetAddress$Addresses2DnsCacheEntry(host, addresses);
    }

    public static DnsCache listInetAddressCache() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        ArrayList<DnsCacheEntry> retCache = new ArrayList<DnsCacheEntry>();
        ArrayList<DnsCacheEntry> retNegativeCache = new ArrayList<DnsCacheEntry>();
        ConcurrentMap<String, Object> cache = InetAddressCacheUtilForNew.getCacheOfInetAddress();
        for (Map.Entry entry : cache.entrySet()) {
            String host = (String)entry.getKey();
            DnsCacheEntry dnsCacheEntry = InetAddressCacheUtilForNew.inetAddress$Addresses2DnsCacheEntry(host, entry.getValue());
            if (dnsCacheEntry.getIps().length == 0) {
                retNegativeCache.add(dnsCacheEntry);
                continue;
            }
            retCache.add(dnsCacheEntry);
        }
        return new DnsCache(retCache, retNegativeCache);
    }

    private static DnsCacheEntry inetAddress$Addresses2DnsCacheEntry(String host, Object addresses) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        String addressesClassName = addresses.getClass().getName();
        InetAddressCacheUtilForNew.initFieldsOfAddresses();
        if (!addressesClassName.equals(inetAddress$CachedAddresses_ClassName)) {
            if (addressesClassName.equals(inetAddress$NameServiceAddresses_ClassName)) {
                throw new IllegalStateException("child class " + addressesClassName + " for class InetAddress.Addresses should never happens, report issue for dns-cache-manipulator lib!");
            }
            throw new IllegalStateException("JDK add new child class " + addressesClassName + " for class InetAddress.Addresses, report issue for dns-cache-manipulator lib!");
        }
        InetAddress[] inetAddresses = (InetAddress[])inetAddressesFieldOfInetAddress$CacheAddress.get(addresses);
        long expiryTimeNanos = expiryTimeFieldOfInetAddress$CacheAddress.getLong(addresses);
        long expiration = TimeUtil.convertNanoTimeToTimeMillis(expiryTimeNanos);
        String[] ips = InetAddressCacheUtilCommons.getIpFromInetAddress(inetAddresses);
        return new DnsCacheEntry(host, ips, expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initFieldsOfAddresses() throws ClassNotFoundException, NoSuchFieldException {
        if (inetAddressesFieldOfInetAddress$CacheAddress != null) {
            return;
        }
        Class<InetAddressCacheUtilForNew> clazz = InetAddressCacheUtilForNew.class;
        synchronized (InetAddressCacheUtilForNew.class) {
            if (inetAddressesFieldOfInetAddress$CacheAddress != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            Class<?> cachedAddresses_Class = Class.forName(inetAddress$CachedAddresses_ClassName);
            Field inetAddressesFiled = cachedAddresses_Class.getDeclaredField("inetAddresses");
            inetAddressesFiled.setAccessible(true);
            inetAddressesFieldOfInetAddress$CacheAddress = inetAddressesFiled;
            Field expiryTimeFiled = cachedAddresses_Class.getDeclaredField("expiryTime");
            expiryTimeFiled.setAccessible(true);
            expiryTimeFieldOfInetAddress$CacheAddress = expiryTimeFiled;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void clearInetAddressCache() throws NoSuchFieldException, IllegalAccessException {
        InetAddressCacheUtilForNew.getExpirySetOfInetAddress().clear();
        InetAddressCacheUtilForNew.getCacheOfInetAddress().clear();
    }

    private InetAddressCacheUtilForNew() {
    }
}

