/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.utils;

import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalMessageItemBase;
import com.alibaba.dashscope.common.MultiModalMessage;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.utils.OSSUploadCertificate;
import com.alibaba.dashscope.utils.OSSUtils;
import com.alibaba.dashscope.utils.UploadResult;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PreprocessMessageInput {
    public static boolean isValidPath(String pathString) {
        try {
            Paths.get(pathString, new String[0]);
            return true;
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public static CheckAndUploadResult checkAndUpload(String model, MultiModalMessageItemBase message, String apiKey, OSSUploadCertificate certificate) throws NoApiKeyException, UploadFileException {
        File f;
        boolean isUpload = false;
        OSSUploadCertificate cert = certificate;
        if (!message.getModal().equals("text") && message.getContent().startsWith("file://")) {
            try {
                UploadResult result;
                URI fileURI = new URI(message.getContent());
                File f2 = new File(fileURI);
                if (f2.exists()) {
                    result = OSSUtils.uploadWithCertificate(model, f2.getAbsolutePath(), apiKey, cert);
                    if (result.getOssUrl() == null) {
                        throw new UploadFileException(String.format("Uploading file: %s failed", message.getContent()));
                    }
                } else {
                    throw new UploadFileException(String.format("Local file: %s not exists.", message.getContent()));
                }
                message.setContent(result.getOssUrl());
                cert = result.getCertificate();
                isUpload = true;
            }
            catch (URISyntaxException e) {
                throw new UploadFileException(e.getMessage());
            }
        } else if (!message.getModal().equals("text") && message.getContent().startsWith("oss://")) {
            isUpload = true;
        } else if (!message.getModal().equals("text") && !message.getContent().startsWith("http") && PreprocessMessageInput.isValidPath(message.getContent()) && (f = new File(message.getContent())).exists()) {
            UploadResult result = OSSUtils.uploadWithCertificate(model, f.getAbsolutePath(), apiKey, cert);
            if (result.getOssUrl() == null) {
                throw new UploadFileException(String.format("Uploading file: %s failed", message.getContent()));
            }
            message.setContent(result.getOssUrl());
            cert = result.getCertificate();
            isUpload = true;
        }
        return new CheckAndUploadResult(isUpload, cert);
    }

    public static <T extends MultiModalMessageItemBase> PreprocessResult preProcessMessageInputs(String model, List<T> messages, String apiKey, OSSUploadCertificate certificate) throws NoApiKeyException, UploadFileException {
        boolean hasUpload = false;
        OSSUploadCertificate cert = certificate;
        for (MultiModalMessageItemBase elem : messages) {
            CheckAndUploadResult result = PreprocessMessageInput.checkAndUpload(model, elem, apiKey, cert);
            if (result.isUpload() && !hasUpload) {
                hasUpload = true;
            }
            cert = result.getCertificate();
        }
        return new PreprocessResult(hasUpload, cert);
    }

    public static <T extends MultiModalMessageItemBase> boolean preProcessMessageInputs(String model, List<T> messages, String apiKey) throws NoApiKeyException, UploadFileException {
        PreprocessResult result = PreprocessMessageInput.preProcessMessageInputs(model, messages, apiKey, null);
        return result.hasUpload();
    }

    public static CheckAndUploadOneResult checkAndUploadOneMultiModalMessage(String model, String apiKey, String key, String value, OSSUploadCertificate certificate) throws NoApiKeyException, UploadFileException {
        File f;
        String dstValue = value;
        OSSUploadCertificate cert = certificate;
        if (value.startsWith("file://")) {
            try {
                UploadResult result;
                URI fileURI = new URI(value);
                File f2 = new File(fileURI);
                if (f2.exists()) {
                    result = OSSUtils.uploadWithCertificate(model, f2.getAbsolutePath(), apiKey, cert);
                    if (result.getOssUrl() == null) {
                        throw new UploadFileException(String.format("Uploading file: %s failed", value));
                    }
                } else {
                    throw new UploadFileException(String.format("Local file: %s not exists.", value));
                }
                dstValue = result.getOssUrl();
                cert = result.getCertificate();
            }
            catch (URISyntaxException e) {
                throw new UploadFileException(e.getMessage());
            }
        } else if (!key.equals("text") && !value.startsWith("http") && PreprocessMessageInput.isValidPath(value) && (f = new File(value)).exists()) {
            UploadResult result = OSSUtils.uploadWithCertificate(model, f.getAbsolutePath(), apiKey, cert);
            if (result.getOssUrl() == null) {
                throw new UploadFileException(String.format("Uploading file: %s failed", value));
            }
            dstValue = result.getOssUrl();
            cert = result.getCertificate();
        }
        return new CheckAndUploadOneResult(dstValue, cert);
    }

    public static String checkAndUploadOneMultiModalMessage(String model, String apiKey, String key, String value) throws NoApiKeyException, UploadFileException {
        CheckAndUploadOneResult result = PreprocessMessageInput.checkAndUploadOneMultiModalMessage(model, apiKey, key, value, null);
        return result.getFileUrl();
    }

    public static CheckAndUploadResult checkAndUploadMultiModalMessage(String model, Map.Entry<String, Object> entry, String apiKey, OSSUploadCertificate certificate) throws NoApiKeyException, UploadFileException {
        boolean isUpload = false;
        OSSUploadCertificate cert = certificate;
        String key = entry.getKey();
        Object value = entry.getValue();
        if (value instanceof List) {
            List dstValue = (List)value;
            for (int i = 0; i < dstValue.size(); ++i) {
                Object v = dstValue.get(i);
                if (!(v instanceof String)) continue;
                if (!key.equals("text") && ((String)v).startsWith("oss://")) {
                    isUpload = true;
                    continue;
                }
                CheckAndUploadOneResult result = PreprocessMessageInput.checkAndUploadOneMultiModalMessage(model, apiKey, key, (String)v, cert);
                if (!result.getFileUrl().equals(v)) {
                    isUpload = true;
                    dstValue.set(i, result.getFileUrl());
                }
                cert = result.getCertificate();
            }
            entry.setValue(dstValue);
        } else if (value instanceof String) {
            if (!key.equals("text") && ((String)value).startsWith("oss://")) {
                isUpload = true;
            } else {
                CheckAndUploadOneResult result = PreprocessMessageInput.checkAndUploadOneMultiModalMessage(model, apiKey, key, (String)value, cert);
                if (!result.getFileUrl().equals(value)) {
                    isUpload = true;
                    entry.setValue(result.getFileUrl());
                }
                cert = result.getCertificate();
            }
        }
        return new CheckAndUploadResult(isUpload, cert);
    }

    public static boolean checkAndUploadMultiModalMessage(String model, Map.Entry<String, Object> entry, String apiKey) throws NoApiKeyException, UploadFileException {
        CheckAndUploadResult result = PreprocessMessageInput.checkAndUploadMultiModalMessage(model, entry, apiKey, null);
        return result.isUpload();
    }

    public static PreprocessResult preProcessMultiModalMessageInputs(String model, MultiModalMessage messages, String apiKey, OSSUploadCertificate certificate) throws NoApiKeyException, UploadFileException {
        boolean hasUpload = false;
        OSSUploadCertificate cert = certificate;
        ArrayList<Map<String, Object>> content = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> item : messages.getContent()) {
            content.add(new HashMap<String, Object>(item));
        }
        for (Map<String, Object> item : content) {
            for (Map.Entry<String, Object> entry : item.entrySet()) {
                CheckAndUploadResult result = PreprocessMessageInput.checkAndUploadMultiModalMessage(model, entry, apiKey, cert);
                if (result.isUpload() && !hasUpload) {
                    hasUpload = true;
                }
                cert = result.getCertificate();
            }
        }
        messages.setContent(content);
        return new PreprocessResult(hasUpload, cert);
    }

    public static boolean preProcessMultiModalMessageInputs(String model, MultiModalMessage messages, String apiKey) throws NoApiKeyException, UploadFileException {
        PreprocessResult result = PreprocessMessageInput.preProcessMultiModalMessageInputs(model, messages, apiKey, null);
        return result.hasUpload();
    }

    public static class PreprocessResult {
        private boolean hasUpload;
        private OSSUploadCertificate certificate;

        public PreprocessResult(boolean hasUpload, OSSUploadCertificate certificate) {
            this.hasUpload = hasUpload;
            this.certificate = certificate;
        }

        public boolean hasUpload() {
            return this.hasUpload;
        }

        public OSSUploadCertificate getCertificate() {
            return this.certificate;
        }
    }

    public static class CheckAndUploadOneResult {
        private String fileUrl;
        private OSSUploadCertificate certificate;

        public CheckAndUploadOneResult(String fileUrl, OSSUploadCertificate certificate) {
            this.fileUrl = fileUrl;
            this.certificate = certificate;
        }

        public String getFileUrl() {
            return this.fileUrl;
        }

        public OSSUploadCertificate getCertificate() {
            return this.certificate;
        }
    }

    public static class CheckAndUploadResult {
        private boolean upload;
        private OSSUploadCertificate certificate;

        public CheckAndUploadResult(boolean upload, OSSUploadCertificate certificate) {
            this.upload = upload;
            this.certificate = certificate;
        }

        public boolean isUpload() {
            return this.upload;
        }

        public OSSUploadCertificate getCertificate() {
            return this.certificate;
        }
    }
}

