/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.utils;

import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.utils.OSSUploadCertificate;
import com.alibaba.dashscope.utils.OSSUtils;
import com.alibaba.dashscope.utils.UploadResult;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public final class PreprocessInputImage {
    public static CheckAndUploadImageResult checkAndUploadImages(String model, Map<String, String> values, String apiKey, OSSUploadCertificate certificate) throws NoApiKeyException, UploadFileException {
        boolean isUpload = false;
        OSSUploadCertificate cert = certificate;
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String v = entry.getValue();
            if (v == null || v.isEmpty()) continue;
            CheckAndUploadOneImageResult result = PreprocessInputImage.checkAndUploadOneImage(model, apiKey, v, cert);
            if (!result.getFileUrl().equals(v)) {
                isUpload = true;
                entry.setValue(result.getFileUrl());
            }
            cert = result.getCertificate();
        }
        return new CheckAndUploadImageResult(isUpload, cert);
    }

    public static boolean checkAndUploadImage(String model, Map<String, String> values, String apiKey) throws NoApiKeyException, UploadFileException {
        CheckAndUploadImageResult result = PreprocessInputImage.checkAndUploadImages(model, values, apiKey, null);
        return result.isUpload();
    }

    public static CheckAndUploadOneImageResult checkAndUploadOneImage(String model, String apiKey, String value, OSSUploadCertificate certificate) throws NoApiKeyException, UploadFileException {
        String dstValue = value;
        OSSUploadCertificate cert = certificate;
        if (value.startsWith("http")) {
            return new CheckAndUploadOneImageResult(dstValue, cert);
        }
        if (value.startsWith("file://")) {
            try {
                UploadResult result;
                URI fileURI = new URI(value);
                File f = new File(fileURI);
                if (f.exists()) {
                    result = OSSUtils.uploadWithCertificate(model, f.getAbsolutePath(), apiKey, cert);
                    if (result.getOssUrl().isEmpty()) {
                        throw new UploadFileException(String.format("Uploading file: %s failed", value));
                    }
                } else {
                    throw new UploadFileException(String.format("Local file: %s not exists.", value));
                }
                dstValue = result.getOssUrl();
                cert = result.getCertificate();
            }
            catch (URISyntaxException e) {
                throw new UploadFileException(e.getMessage());
            }
        }
        return new CheckAndUploadOneImageResult(dstValue, cert);
    }

    public static String checkAndUploadImage(String model, String apiKey, String value) throws NoApiKeyException, UploadFileException {
        CheckAndUploadOneImageResult result = PreprocessInputImage.checkAndUploadOneImage(model, apiKey, value, null);
        return result.getFileUrl();
    }

    public static class CheckAndUploadOneImageResult {
        private String fileUrl;
        private OSSUploadCertificate certificate;

        public CheckAndUploadOneImageResult(String fileUrl, OSSUploadCertificate certificate) {
            this.fileUrl = fileUrl;
            this.certificate = certificate;
        }

        public String getFileUrl() {
            return this.fileUrl;
        }

        public OSSUploadCertificate getCertificate() {
            return this.certificate;
        }
    }

    public static class CheckAndUploadImageResult {
        private boolean upload;
        private OSSUploadCertificate certificate;

        public CheckAndUploadImageResult(boolean upload, OSSUploadCertificate certificate) {
            this.upload = upload;
            this.certificate = certificate;
        }

        public boolean isUpload() {
            return this.upload;
        }

        public OSSUploadCertificate getCertificate() {
            return this.certificate;
        }
    }
}

