/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.multimodal.tingwu;

import com.alibaba.dashscope.api.SynchronizeFullDuplexApi;
import com.alibaba.dashscope.base.FullDuplexParamBase;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.multimodal.tingwu.TingWuRealtimeCallback;
import com.alibaba.dashscope.multimodal.tingwu.TingWuRealtimeParam;
import com.alibaba.dashscope.multimodal.tingwu.TingWuRealtimeResult;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TingWuRealtime {
    private static final Logger log = LoggerFactory.getLogger(TingWuRealtime.class);
    SynchronizeFullDuplexApi<TingWuRealtimeWithStream> duplexApi;
    private ApiServiceOption serviceOption;
    private Emitter<ByteBuffer> audioEmitter;
    private final Queue<AsyncCmdBuffer> cmdBuffer = new LinkedList<AsyncCmdBuffer>();
    private AtomicReference<CountDownLatch> stopLatch = new AtomicReference<Object>(null);
    private long startStreamTimeStamp = -1L;
    private long firstPackageTimeStamp = -1L;
    private long stopStreamTimeStamp = -1L;
    private long onCompleteTimeStamp = -1L;
    private String preRequestId = null;
    private boolean isListenState = false;

    public TingWuRealtime() {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.ASR.getValue())).function(Function.RECOGNITION.getValue())).build();
        this.duplexApi = new SynchronizeFullDuplexApi(this.serviceOption);
    }

    public TingWuRealtime(String baseUrl) {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AIGC.getValue())).task(Task.MULTIMODAL_GENERATION.getValue())).function(Function.GENERATION.getValue())).baseWebSocketUrl(baseUrl)).build();
        this.duplexApi = new SynchronizeFullDuplexApi(this.serviceOption);
    }

    public TingWuRealtime(String baseUrl, ConnectionOptions connectionOptions) {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.ASR.getValue())).function(Function.SPEECH_TRANSLATION.getValue())).baseWebSocketUrl(baseUrl)).build();
        this.duplexApi = new SynchronizeFullDuplexApi(connectionOptions, this.serviceOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(TingWuRealtimeParam param, final TingWuRealtimeCallback callback) {
        block7: {
            this.reset();
            if (param == null) {
                throw new ApiException(new InputRequiredException("Parameter invalid: TranslationRecognizerParam is null"));
            }
            if (callback == null) {
                throw new ApiException(new InputRequiredException("Parameter invalid: ResultCallback is null"));
            }
            Flowable audioFrames = Flowable.create(emitter -> {
                TingWuRealtime tingWuRealtime = this;
                synchronized (tingWuRealtime) {
                    if (this.cmdBuffer.size() > 0) {
                        for (AsyncCmdBuffer buffer : this.cmdBuffer) {
                            if (buffer.isStop) {
                                emitter.onComplete();
                                return;
                            }
                            emitter.onNext((Object)buffer.audioFrame);
                        }
                        this.cmdBuffer.clear();
                    }
                    this.audioEmitter = emitter;
                }
            }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
            TingWuRealtime tingWuRealtime = this;
            synchronized (tingWuRealtime) {
                this.cmdBuffer.clear();
            }
            this.stopLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
            try {
                this.duplexApi.duplexCall(TingWuRealtimeWithStream.FromTingWuRealtimeParam(param, (Flowable<ByteBuffer>)audioFrames, this.preRequestId), new ResultCallback<DashScopeResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onEvent(DashScopeResult message) {
                        log.debug("Response Result :" + message);
                        TingWuRealtimeResult tingWuRealtimeResult = TingWuRealtimeResult.fromDashScopeResult(message);
                        switch (tingWuRealtimeResult.getAction()) {
                            case "speech-listen": {
                                callback.onStarted(tingWuRealtimeResult.getTaskId());
                                TingWuRealtime tingWuRealtime = TingWuRealtime.this;
                                synchronized (tingWuRealtime) {
                                    TingWuRealtime.this.isListenState = true;
                                }
                                callback.onSpeechListen(tingWuRealtimeResult.getTaskId(), tingWuRealtimeResult.getOutput().get("dataId").getAsString());
                                break;
                            }
                            case "task-failed": {
                                callback.onError(tingWuRealtimeResult.getOutput().get("errorCode").getAsString(), tingWuRealtimeResult.getOutput().get("errorMessage").getAsString());
                                break;
                            }
                            case "recognize-result": {
                                callback.onRecognizeResult(tingWuRealtimeResult.getTaskId(), tingWuRealtimeResult.getOutput());
                                break;
                            }
                            case "ai-result": {
                                callback.onAiResult(tingWuRealtimeResult.getTaskId(), tingWuRealtimeResult.getOutput());
                                break;
                            }
                            case "speech-end": {
                                callback.onStopped(tingWuRealtimeResult.getTaskId());
                            }
                        }
                    }

                    @Override
                    public void onComplete() {
                        TingWuRealtime.this.onCompleteTimeStamp = System.currentTimeMillis();
                        log.debug("last package delay: " + TingWuRealtime.this.getLastPackageDelay());
                        callback.onClosed();
                        if (TingWuRealtime.this.stopLatch.get() != null) {
                            ((CountDownLatch)TingWuRealtime.this.stopLatch.get()).countDown();
                        }
                    }

                    @Override
                    public void onError(Exception e) {
                        ApiException apiException = new ApiException(e);
                        apiException.setStackTrace(e.getStackTrace());
                        callback.onError(apiException.getStatus().getCode(), apiException.getMessage());
                        if (TingWuRealtime.this.stopLatch.get() != null) {
                            ((CountDownLatch)TingWuRealtime.this.stopLatch.get()).countDown();
                        }
                    }
                });
            }
            catch (NoApiKeyException e) {
                ApiException apiException = new ApiException(e);
                apiException.setStackTrace(e.getStackTrace());
                callback.onError(apiException.getStatus().getCode(), apiException.getMessage());
                if (this.stopLatch.get() == null) break block7;
                this.stopLatch.get().countDown();
            }
        }
        log.debug("TingWu Realtime client started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAudioFrame(ByteBuffer audioFrame) {
        if (audioFrame == null) {
            throw new ApiException(new InputRequiredException("Parameter invalid: audioFrame is null"));
        }
        if (this.startStreamTimeStamp < 0L) {
            this.startStreamTimeStamp = System.currentTimeMillis();
        }
        log.debug("send audio frame: " + audioFrame.remaining());
        TingWuRealtime tingWuRealtime = this;
        synchronized (tingWuRealtime) {
            if (this.audioEmitter == null || !this.isListenState) {
                this.cmdBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().audioFrame(audioFrame)).build());
            } else {
                this.audioEmitter.onNext((Object)audioFrame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopStreamTimeStamp = System.currentTimeMillis();
        TingWuRealtime tingWuRealtime = this;
        synchronized (tingWuRealtime) {
            if (this.audioEmitter == null) {
                this.cmdBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().isStop(true)).build());
            } else {
                this.audioEmitter.onComplete();
            }
        }
        if (this.stopLatch.get() != null) {
            try {
                this.stopLatch.get().await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void reset() {
        this.audioEmitter = null;
        this.cmdBuffer.clear();
        this.isListenState = false;
        this.stopLatch = new AtomicReference<Object>(null);
        this.startStreamTimeStamp = -1L;
        this.firstPackageTimeStamp = -1L;
        this.stopStreamTimeStamp = -1L;
        this.onCompleteTimeStamp = -1L;
        this.preRequestId = null;
    }

    public long getFirstPackageDelay() {
        return this.firstPackageTimeStamp - this.startStreamTimeStamp;
    }

    public long getLastPackageDelay() {
        return this.onCompleteTimeStamp - this.stopStreamTimeStamp;
    }

    public String getLastRequestId() {
        return this.preRequestId;
    }

    public SynchronizeFullDuplexApi<TingWuRealtimeWithStream> getDuplexApi() {
        return this.duplexApi;
    }

    private static class TingWuRealtimeWithStream
    extends TingWuRealtimeParam {
        @NonNull
        private Flowable<ByteBuffer> audioStream;

        @Override
        public Flowable<Object> getStreamingData() {
            return this.audioStream.cast(Object.class);
        }

        public static TingWuRealtimeWithStream FromTingWuRealtimeParam(TingWuRealtimeParam param, Flowable<ByteBuffer> audioStream, String preRequestId) {
            TingWuRealtimeParam tingWuRealtimeWithStream = ((TingWuRealtimeWithStreamBuilder)((TingWuRealtimeWithStreamBuilder)((TingWuRealtimeWithStreamBuilder)((FullDuplexParamBase.FullDuplexParamBaseBuilder)((TingWuRealtimeWithStreamBuilder)((TingWuRealtimeWithStreamBuilder)((TingWuRealtimeWithStreamBuilder)((TingWuRealtimeWithStreamBuilder)((TingWuRealtimeWithStreamBuilder)TingWuRealtimeWithStream.builder().parameters(param.getParameters())).headers(param.getHeaders())).appId(param.getAppId())).format(param.getFormat())).input(param.getInput())).audioStream(audioStream)).model(param.getModel())).sampleRate(param.getSampleRate())).apiKey(param.getApiKey())).build();
            tingWuRealtimeWithStream.setDirective("start");
            return tingWuRealtimeWithStream;
        }

        protected TingWuRealtimeWithStream(TingWuRealtimeWithStreamBuilder<?, ?> b) {
            super((TingWuRealtimeParam.TingWuRealtimeParamBuilder<?, ?>)b);
            this.audioStream = ((TingWuRealtimeWithStreamBuilder)b).audioStream;
            if (this.audioStream == null) {
                throw new NullPointerException("audioStream is marked non-null but is null");
            }
        }

        public static TingWuRealtimeWithStreamBuilder<?, ?> builder() {
            return new TingWuRealtimeWithStreamBuilderImpl();
        }

        private static final class TingWuRealtimeWithStreamBuilderImpl
        extends TingWuRealtimeWithStreamBuilder<TingWuRealtimeWithStream, TingWuRealtimeWithStreamBuilderImpl> {
            private TingWuRealtimeWithStreamBuilderImpl() {
            }

            @Override
            protected TingWuRealtimeWithStreamBuilderImpl self() {
                return this;
            }

            @Override
            public TingWuRealtimeWithStream build() {
                return new TingWuRealtimeWithStream(this);
            }
        }

        public static abstract class TingWuRealtimeWithStreamBuilder<C extends TingWuRealtimeWithStream, B extends TingWuRealtimeWithStreamBuilder<C, B>>
        extends TingWuRealtimeParam.TingWuRealtimeParamBuilder<C, B> {
            private Flowable<ByteBuffer> audioStream;

            public B audioStream(@NonNull Flowable<ByteBuffer> audioStream) {
                if (audioStream == null) {
                    throw new NullPointerException("audioStream is marked non-null but is null");
                }
                this.audioStream = audioStream;
                return (B)this.self();
            }

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "TingWuRealtime.TingWuRealtimeWithStream.TingWuRealtimeWithStreamBuilder(super=" + super.toString() + ", audioStream=" + this.audioStream + ")";
            }
        }
    }

    private static class AsyncCmdBuffer {
        private boolean isStop;
        private ByteBuffer audioFrame;

        private static boolean $default$isStop() {
            return false;
        }

        protected AsyncCmdBuffer(AsyncCmdBufferBuilder<?, ?> b) {
            this.isStop = ((AsyncCmdBufferBuilder)b).isStop$set ? ((AsyncCmdBufferBuilder)b).isStop$value : AsyncCmdBuffer.$default$isStop();
            this.audioFrame = ((AsyncCmdBufferBuilder)b).audioFrame;
        }

        public static AsyncCmdBufferBuilder<?, ?> builder() {
            return new AsyncCmdBufferBuilderImpl();
        }

        private static final class AsyncCmdBufferBuilderImpl
        extends AsyncCmdBufferBuilder<AsyncCmdBuffer, AsyncCmdBufferBuilderImpl> {
            private AsyncCmdBufferBuilderImpl() {
            }

            @Override
            protected AsyncCmdBufferBuilderImpl self() {
                return this;
            }

            @Override
            public AsyncCmdBuffer build() {
                return new AsyncCmdBuffer(this);
            }
        }

        public static abstract class AsyncCmdBufferBuilder<C extends AsyncCmdBuffer, B extends AsyncCmdBufferBuilder<C, B>> {
            private boolean isStop$set;
            private boolean isStop$value;
            private ByteBuffer audioFrame;

            public B isStop(boolean isStop) {
                this.isStop$value = isStop;
                this.isStop$set = true;
                return this.self();
            }

            public B audioFrame(ByteBuffer audioFrame) {
                this.audioFrame = audioFrame;
                return this.self();
            }

            protected abstract B self();

            public abstract C build();

            public String toString() {
                return "TingWuRealtime.AsyncCmdBuffer.AsyncCmdBufferBuilder(isStop$value=" + this.isStop$value + ", audioFrame=" + this.audioFrame + ")";
            }
        }
    }
}

