/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.multimodal;

import com.alibaba.dashscope.api.SynchronizeFullDuplexApi;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.multimodal.MultiModalDialogCallback;
import com.alibaba.dashscope.multimodal.MultiModalRequestParam;
import com.alibaba.dashscope.multimodal.State;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonObject;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiModalDialog {
    private static final Logger log = LoggerFactory.getLogger(MultiModalDialog.class);
    SynchronizeFullDuplexApi<MultiModalRequestParam> duplexApi;
    private ApiServiceOption serviceOption;
    private ConnectionOptions connectionOptions;
    private Emitter<Object> conversationEmitter;
    private MultiModalRequestParam requestParam;
    private MultiModalDialogCallback callback;
    private MultiModalRequestParamWithStream requestParamWithStream;
    private State.DialogState currentState = State.DialogState.IDLE;
    private String currentDialogId = "";
    private final Queue<AsyncCmdBuffer> DialogBuffer = new LinkedList<AsyncCmdBuffer>();
    private AtomicReference<CountDownLatch> stopLatch = new AtomicReference<Object>(null);

    public MultiModalDialog(MultiModalRequestParam param, MultiModalDialogCallback callback) {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AIGC.getValue())).task(Task.MULTIMODAL_GENERATION.getValue())).function(Function.GENERATION.getValue())).passTaskStarted(true)).build();
        this.requestParam = param;
        this.callback = callback;
        this.connectionOptions = ConnectionOptions.builder().build();
        this.connectionOptions.setUseDefaultClient(false);
        this.duplexApi = new SynchronizeFullDuplexApi(this.connectionOptions, this.serviceOption);
    }

    public MultiModalDialog(MultiModalRequestParam param, MultiModalDialogCallback callback, ConnectionOptions connectionOptions) {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AIGC.getValue())).task(Task.MULTIMODAL_GENERATION.getValue())).function(Function.GENERATION.getValue())).passTaskStarted(true)).build();
        this.connectionOptions = connectionOptions;
        this.connectionOptions.setUseDefaultClient(false);
        this.requestParam = param;
        this.callback = callback;
        this.duplexApi = new SynchronizeFullDuplexApi(this.connectionOptions, this.serviceOption);
    }

    public MultiModalDialog(MultiModalRequestParam param, MultiModalDialogCallback callback, ApiServiceOption serviceOption) {
        this.requestParam = param;
        this.callback = callback;
        this.serviceOption = serviceOption;
        this.duplexApi = new SynchronizeFullDuplexApi(serviceOption);
    }

    public void start() {
        block2: {
            Flowable dataFrames = Flowable.create(emitter -> {
                MultiModalDialog multiModalDialog = this;
                synchronized (multiModalDialog) {
                    if (!this.DialogBuffer.isEmpty()) {
                        for (AsyncCmdBuffer buffer : this.DialogBuffer) {
                            if (buffer.isStop) {
                                emitter.onComplete();
                                return;
                            }
                            if (buffer.directive != null) {
                                emitter.onNext((Object)buffer.directive);
                                continue;
                            }
                            emitter.onNext((Object)buffer.audioFrame);
                        }
                        this.DialogBuffer.clear();
                    }
                    this.conversationEmitter = emitter;
                }
            }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
            this.stopLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
            this.requestParamWithStream = MultiModalRequestParamWithStream.FromMultiModalParam(this.requestParam, (Flowable<Object>)dataFrames, UUID.randomUUID().toString());
            try {
                this.duplexApi.duplexCall(this.requestParamWithStream, new ResultCallback<DashScopeResult>(){

                    @Override
                    public void onEvent(DashScopeResult message) {
                        if (message.isBinaryOutput().booleanValue()) {
                            MultiModalDialog.this.callback.onSpeechAudioData((ByteBuffer)message.getOutput());
                            return;
                        }
                        log.info("onEvent: {}", (Object)message);
                        if (message.getOutput() != null) {
                            JsonObject output = (JsonObject)message.getOutput();
                            String dialogId = null;
                            if (output.has("dialog_id")) {
                                dialogId = output.get("dialog_id").getAsString();
                            }
                            switch (output.get("event").getAsString()) {
                                case "Started": {
                                    MultiModalDialog.this.currentDialogId = dialogId;
                                    MultiModalDialog.this.callback.onStarted(dialogId);
                                    break;
                                }
                                case "Stopped": {
                                    MultiModalDialog.this.callback.onStopped(dialogId);
                                    MultiModalDialog.this.sendFinishTaskMessage();
                                    break;
                                }
                                case "Error": {
                                    String error_code = output.has("error_code") ? output.get("error_code").getAsString() : "";
                                    MultiModalDialog.this.callback.onError(dialogId, error_code, output.has("error_message") ? output.get("error_message").getAsString() : "");
                                    break;
                                }
                                case "DialogStateChanged": {
                                    switch (output.get("state").getAsString()) {
                                        case "Idle": {
                                            MultiModalDialog.this.currentState = State.DialogState.IDLE;
                                            break;
                                        }
                                        case "Listening": {
                                            MultiModalDialog.this.currentState = State.DialogState.LISTENING;
                                            break;
                                        }
                                        case "Thinking": {
                                            MultiModalDialog.this.currentState = State.DialogState.THINKING;
                                            break;
                                        }
                                        case "Responding": {
                                            MultiModalDialog.this.currentState = State.DialogState.RESPONDING;
                                        }
                                    }
                                    MultiModalDialog.this.callback.onStateChanged(MultiModalDialog.this.currentState);
                                    break;
                                }
                                case "RequestAccepted": {
                                    MultiModalDialog.this.callback.onRequestAccepted(dialogId);
                                    break;
                                }
                                case "SpeechStarted": {
                                    MultiModalDialog.this.callback.onSpeechStarted(dialogId);
                                    break;
                                }
                                case "SpeechEnded": {
                                    MultiModalDialog.this.callback.onSpeechEnded(dialogId);
                                    break;
                                }
                                case "RespondingStarted": {
                                    MultiModalDialog.this.callback.onRespondingStarted(dialogId);
                                    break;
                                }
                                case "RespondingEnded": {
                                    MultiModalDialog.this.callback.onRespondingEnded(dialogId, output);
                                    break;
                                }
                                case "SpeechContent": {
                                    MultiModalDialog.this.callback.onSpeechContent(dialogId, output);
                                    break;
                                }
                                case "RespondingContent": {
                                    MultiModalDialog.this.callback.onRespondingContent(dialogId, output);
                                    break;
                                }
                            }
                        } else if (message.getEvent() != null && message.getEvent().equals("task-started")) {
                            MultiModalDialog.this.callback.onConnected();
                            log.debug("MultiModalDialog connected, state is {}", (Object)MultiModalDialog.this.currentState.getValue());
                        }
                    }

                    @Override
                    public void onComplete() {
                        if (MultiModalDialog.this.stopLatch.get() != null) {
                            ((CountDownLatch)MultiModalDialog.this.stopLatch.get()).countDown();
                        }
                        MultiModalDialog.this.callback.onClosed();
                    }

                    @Override
                    public void onError(Exception e) {
                        if (e instanceof ApiException) {
                            ApiException apiException = (ApiException)e;
                            if (apiException.getStatus().isJson()) {
                                MultiModalDialog.this.callback.onError(apiException.getStatus().getRequestId(), apiException.getStatus().getCode(), apiException.getStatus().getMessage());
                            } else {
                                MultiModalDialog.this.callback.onError(MultiModalDialog.this.currentDialogId, "", apiException.getMessage());
                            }
                        } else {
                            MultiModalDialog.this.callback.onError(MultiModalDialog.this.currentDialogId, "", e.getMessage());
                        }
                        if (MultiModalDialog.this.stopLatch.get() != null) {
                            ((CountDownLatch)MultiModalDialog.this.stopLatch.get()).countDown();
                        }
                    }
                });
            }
            catch (NoApiKeyException e) {
                ApiException apiException = new ApiException(e);
                this.callback.onError("", "", apiException.getMessage());
                if (this.stopLatch.get() == null) break block2;
                this.stopLatch.get().countDown();
            }
        }
    }

    public void startSpeech() {
        this.sendTextFrame("SendSpeech");
    }

    public void stopSpeech() {
        this.sendTextFrame("StopSpeech");
    }

    public void interrupt() {
        this.sendTextFrame("RequestToSpeak");
    }

    public void localRespondingStarted() {
        this.sendTextFrame("LocalRespondingStarted");
    }

    public void localRespondingEnded() {
        this.sendTextFrame("LocalRespondingEnded");
    }

    public void sendHeartBeat() {
        this.sendTextFrame("HeartBeat");
    }

    public void requestToRespond(String type, String text, MultiModalRequestParam.UpdateParams updateParams) {
        this.requestParamWithStream.clearParameters();
        MultiModalRequestParam.CustomInput customInput = MultiModalRequestParam.CustomInput.builder().directive("RequestToRespond").dialogId(this.currentDialogId).type(type).text(text).build();
        this.requestParamWithStream.setCustomInput(customInput);
        if (updateParams != null && updateParams.images != null) {
            this.requestParamWithStream.setImages(updateParams.images);
        }
        if (updateParams != null && updateParams.bizParams != null) {
            this.requestParamWithStream.setBizParams(updateParams.bizParams);
        }
        this.sendTextFrame("RequestToRespond");
    }

    public void updateInfo(MultiModalRequestParam.UpdateParams updateParams) {
        this.requestParamWithStream.clearParameters();
        MultiModalRequestParam.CustomInput customInput = MultiModalRequestParam.CustomInput.builder().directive("UpdateInfo").dialogId(this.currentDialogId).build();
        this.requestParamWithStream.setCustomInput(customInput);
        if (updateParams != null && updateParams.clientInfo != null) {
            this.requestParamWithStream.setClientInfo(updateParams.clientInfo);
        }
        if (updateParams != null && updateParams.bizParams != null) {
            this.requestParamWithStream.setBizParams(updateParams.bizParams);
        }
        if (updateParams != null && updateParams.images != null) {
            this.requestParamWithStream.setImages(updateParams.images);
        }
        if (updateParams != null && updateParams.upStream != null) {
            this.requestParamWithStream.setUpStream(updateParams.upStream);
        }
        if (updateParams != null && updateParams.downStream != null) {
            this.requestParamWithStream.setDownStream(updateParams.downStream);
        }
        this.sendTextFrame("UpdateInfo");
    }

    public void stop() {
        this.sendFinishTaskMessage();
        if (this.stopLatch.get() != null) {
            try {
                this.stopLatch.get().await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public State.DialogState getDialogState() {
        return this.currentState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAudioData(ByteBuffer audioFrame) {
        if (audioFrame == null) {
            throw new ApiException(new InputRequiredException("Parameter invalid: audioFrame is null"));
        }
        MultiModalDialog multiModalDialog = this;
        synchronized (multiModalDialog) {
            if (this.conversationEmitter != null) {
                log.debug("submitAudioFrame to new emitter: " + audioFrame);
                this.conversationEmitter.onNext((Object)audioFrame);
            } else {
                this.DialogBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().audioFrame(audioFrame)).build());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTextFrame(String textFrame) {
        if (Objects.equals(textFrame, "")) {
            throw new ApiException(new InputRequiredException("Parameter invalid: text is null"));
        }
        MultiModalDialog multiModalDialog = this;
        synchronized (multiModalDialog) {
            if (this.conversationEmitter != null) {
                log.debug("submitText to new emitter: {}", (Object)textFrame);
                if ("RequestToRespond".equals(textFrame) || "UpdateInfo".equals(textFrame)) {
                    this.conversationEmitter.onNext((Object)JsonUtils.toJson(this.requestParamWithStream.getCustomInput()));
                } else {
                    log.debug("clear parameters");
                    this.requestParamWithStream.clearParameters();
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("directive", textFrame);
                    jsonObject.addProperty("dialog_id", this.currentDialogId);
                    this.conversationEmitter.onNext((Object)jsonObject);
                }
            } else {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("directive", textFrame);
                jsonObject.addProperty("dialog_id", this.currentDialogId);
                this.DialogBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().directive(JsonUtils.toJson(jsonObject))).build());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFinishTaskMessage() {
        MultiModalDialog multiModalDialog = this;
        synchronized (multiModalDialog) {
            if (this.conversationEmitter != null) {
                this.conversationEmitter.onComplete();
            }
        }
    }

    public SynchronizeFullDuplexApi<MultiModalRequestParam> getDuplexApi() {
        return this.duplexApi;
    }

    private static class MultiModalRequestParamWithStream
    extends MultiModalRequestParam {
        @NonNull
        private Flowable<Object> dataStream;

        @Override
        public Flowable<Object> getStreamingData() {
            return this.dataStream.map(item -> {
                if (item instanceof String) {
                    return JsonUtils.parse((String)item);
                }
                if (item instanceof ByteBuffer) {
                    return item;
                }
                if (item instanceof JsonObject) {
                    return item;
                }
                throw new IllegalArgumentException("Unsupported type");
            }).cast(Object.class);
        }

        public static MultiModalRequestParamWithStream FromMultiModalParam(MultiModalRequestParam param, Flowable<Object> dataStream, String preRequestId) {
            MultiModalRequestParam.ClientInfo clientInfo = param.getClientInfo();
            clientInfo.setSdk("dashscope-sdk-java 2.17.0");
            return ((MultiModalRequestParamWithStreamBuilder)((MultiModalRequestParamWithStreamBuilder)((MultiModalRequestParamWithStreamBuilder)((MultiModalRequestParam.MultiModalRequestParamBuilder)((MultiModalRequestParamWithStreamBuilder)((MultiModalRequestParamWithStreamBuilder)((MultiModalRequestParamWithStreamBuilder)((MultiModalRequestParamWithStreamBuilder)((MultiModalRequestParamWithStreamBuilder)((MultiModalRequestParamWithStreamBuilder)((MultiModalRequestParamWithStreamBuilder)((MultiModalRequestParamWithStreamBuilder)((MultiModalRequestParamWithStreamBuilder)MultiModalRequestParamWithStream.builder().parameter("pre_task_id", preRequestId)).headers(param.getHeaders())).upStream(param.getUpStream())).customInput(param.getCustomInput())).bizParams(param.getBizParams())).downStream(param.getDownStream())).clientInfo(clientInfo)).dialogAttributes(param.getDialogAttributes())).images(param.getImages())).dataStream(dataStream)).customInput(param.getCustomInput())).model(param.getModel())).apiKey(param.getApiKey())).build();
        }

        protected MultiModalRequestParamWithStream(MultiModalRequestParamWithStreamBuilder<?, ?> b) {
            super((MultiModalRequestParam.MultiModalRequestParamBuilder<?, ?>)b);
            this.dataStream = ((MultiModalRequestParamWithStreamBuilder)b).dataStream;
            if (this.dataStream == null) {
                throw new NullPointerException("dataStream is marked non-null but is null");
            }
        }

        public static MultiModalRequestParamWithStreamBuilder<?, ?> builder() {
            return new MultiModalRequestParamWithStreamBuilderImpl();
        }

        private static final class MultiModalRequestParamWithStreamBuilderImpl
        extends MultiModalRequestParamWithStreamBuilder<MultiModalRequestParamWithStream, MultiModalRequestParamWithStreamBuilderImpl> {
            private MultiModalRequestParamWithStreamBuilderImpl() {
            }

            @Override
            protected MultiModalRequestParamWithStreamBuilderImpl self() {
                return this;
            }

            @Override
            public MultiModalRequestParamWithStream build() {
                return new MultiModalRequestParamWithStream(this);
            }
        }

        public static abstract class MultiModalRequestParamWithStreamBuilder<C extends MultiModalRequestParamWithStream, B extends MultiModalRequestParamWithStreamBuilder<C, B>>
        extends MultiModalRequestParam.MultiModalRequestParamBuilder<C, B> {
            private Flowable<Object> dataStream;

            public B dataStream(@NonNull Flowable<Object> dataStream) {
                if (dataStream == null) {
                    throw new NullPointerException("dataStream is marked non-null but is null");
                }
                this.dataStream = dataStream;
                return (B)this.self();
            }

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "MultiModalDialog.MultiModalRequestParamWithStream.MultiModalRequestParamWithStreamBuilder(super=" + super.toString() + ", dataStream=" + this.dataStream + ")";
            }
        }
    }

    private static class AsyncCmdBuffer {
        private boolean isStop;
        private ByteBuffer audioFrame;
        private String directive;

        private static boolean $default$isStop() {
            return false;
        }

        protected AsyncCmdBuffer(AsyncCmdBufferBuilder<?, ?> b) {
            this.isStop = ((AsyncCmdBufferBuilder)b).isStop$set ? ((AsyncCmdBufferBuilder)b).isStop$value : AsyncCmdBuffer.$default$isStop();
            this.audioFrame = ((AsyncCmdBufferBuilder)b).audioFrame;
            this.directive = ((AsyncCmdBufferBuilder)b).directive;
        }

        public static AsyncCmdBufferBuilder<?, ?> builder() {
            return new AsyncCmdBufferBuilderImpl();
        }

        private static final class AsyncCmdBufferBuilderImpl
        extends AsyncCmdBufferBuilder<AsyncCmdBuffer, AsyncCmdBufferBuilderImpl> {
            private AsyncCmdBufferBuilderImpl() {
            }

            @Override
            protected AsyncCmdBufferBuilderImpl self() {
                return this;
            }

            @Override
            public AsyncCmdBuffer build() {
                return new AsyncCmdBuffer(this);
            }
        }

        public static abstract class AsyncCmdBufferBuilder<C extends AsyncCmdBuffer, B extends AsyncCmdBufferBuilder<C, B>> {
            private boolean isStop$set;
            private boolean isStop$value;
            private ByteBuffer audioFrame;
            private String directive;

            public B isStop(boolean isStop) {
                this.isStop$value = isStop;
                this.isStop$set = true;
                return this.self();
            }

            public B audioFrame(ByteBuffer audioFrame) {
                this.audioFrame = audioFrame;
                return this.self();
            }

            public B directive(String directive) {
                this.directive = directive;
                return this.self();
            }

            protected abstract B self();

            public abstract C build();

            public String toString() {
                return "MultiModalDialog.AsyncCmdBuffer.AsyncCmdBufferBuilder(isStop$value=" + this.isStop$value + ", audioFrame=" + this.audioFrame + ", directive=" + this.directive + ")";
            }
        }
    }
}

