/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.qwen_asr;

import com.alibaba.dashscope.audio.qwen_asr.QwenTranscriptionMetrics;
import com.alibaba.dashscope.audio.qwen_asr.QwenTranscriptionTaskResult;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.TaskStatus;
import com.alibaba.dashscope.exception.ApiException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public class QwenTranscriptionResult {
    @SerializedName(value="request_id")
    private String requestId;
    private JsonObject output;
    private JsonObject usage;
    private TaskStatus taskStatus;
    private String taskId;
    private QwenTranscriptionTaskResult result;
    private QwenTranscriptionMetrics metrics;

    public static QwenTranscriptionResult fromDashScopeResult(DashScopeResult dashScopeResult) throws ApiException {
        QwenTranscriptionResult result = new QwenTranscriptionResult();
        result.output = (JsonObject)dashScopeResult.getOutput();
        if (dashScopeResult.getUsage() != null) {
            result.usage = dashScopeResult.getUsage().getAsJsonObject();
        }
        result.requestId = dashScopeResult.getRequestId();
        if (dashScopeResult.getOutput() != null) {
            if (result.output.has("task_status")) {
                JsonElement jsonTaskStatus = result.output.get("task_status");
                result.taskStatus = jsonTaskStatus != null ? TaskStatus.valueOf(jsonTaskStatus.getAsString()) : TaskStatus.FAILED;
            }
            result.taskId = result.output.has("task_id") ? result.output.get("task_id").getAsString() : null;
            if (result.output.has("result")) {
                JsonElement jsonResult = result.output.get("result");
                result.result = jsonResult != null ? QwenTranscriptionTaskResult.from(jsonResult.getAsJsonObject()) : new QwenTranscriptionTaskResult();
            }
            if (result.output.has("task_metrics")) {
                JsonElement jsonMetrics = result.output.get("task_metrics");
                if (jsonMetrics != null) {
                    result.setMetrics(QwenTranscriptionMetrics.from(jsonMetrics.getAsJsonObject()));
                } else {
                    result.setMetrics(new QwenTranscriptionMetrics());
                }
            }
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public JsonObject getOutput() {
        return this.output;
    }

    public JsonObject getUsage() {
        return this.usage;
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public QwenTranscriptionTaskResult getResult() {
        return this.result;
    }

    public QwenTranscriptionMetrics getMetrics() {
        return this.metrics;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setOutput(JsonObject output) {
        this.output = output;
    }

    public void setUsage(JsonObject usage) {
        this.usage = usage;
    }

    public void setTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setResult(QwenTranscriptionTaskResult result) {
        this.result = result;
    }

    public void setMetrics(QwenTranscriptionMetrics metrics) {
        this.metrics = metrics;
    }

    public String toString() {
        return "QwenTranscriptionResult(requestId=" + this.getRequestId() + ", output=" + this.getOutput() + ", usage=" + this.getUsage() + ", taskStatus=" + (Object)((Object)this.getTaskStatus()) + ", taskId=" + this.getTaskId() + ", result=" + this.getResult() + ", metrics=" + this.getMetrics() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QwenTranscriptionResult)) {
            return false;
        }
        QwenTranscriptionResult other = (QwenTranscriptionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        JsonObject this$output = this.getOutput();
        JsonObject other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        JsonObject this$usage = this.getUsage();
        JsonObject other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) {
            return false;
        }
        TaskStatus this$taskStatus = this.getTaskStatus();
        TaskStatus other$taskStatus = other.getTaskStatus();
        if (this$taskStatus == null ? other$taskStatus != null : !((Object)((Object)this$taskStatus)).equals((Object)other$taskStatus)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        QwenTranscriptionTaskResult this$result = this.getResult();
        QwenTranscriptionTaskResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        QwenTranscriptionMetrics this$metrics = this.getMetrics();
        QwenTranscriptionMetrics other$metrics = other.getMetrics();
        return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QwenTranscriptionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        JsonObject $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        JsonObject $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        TaskStatus $taskStatus = this.getTaskStatus();
        result = result * 59 + ($taskStatus == null ? 43 : ((Object)((Object)$taskStatus)).hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        QwenTranscriptionTaskResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        QwenTranscriptionMetrics $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        return result;
    }
}

