/*
 * Decompiled with CFR 0.152.
 */
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversation;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationMessage;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalMessageItemImage;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalMessageItemText;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.MultiModalMessage;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.tools.FunctionDefinition;
import com.alibaba.dashscope.tools.ToolFunction;
import com.alibaba.dashscope.utils.JsonUtils;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import io.reactivex.Flowable;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MultiModalConversationQwenVL {
    private static final String modelName = System.getenv("MODEL_NAME");

    public static void imageSample() throws ApiException, NoApiKeyException, UploadFileException {
        MultiModalConversation conversation = new MultiModalConversation();
        MultiModalMessageItemText systemText = new MultiModalMessageItemText("\u4f60\u662f\u8fbe\u6469\u9662\u7684\u751f\u6d3b\u52a9\u624b\u673a\u5668\u4eba\u3002");
        Object systemMessage = ((MultiModalConversationMessage.MultiModalConversationMessageBuilder)((MultiModalConversationMessage.MultiModalConversationMessageBuilder)MultiModalConversationMessage.builder().role(Role.SYSTEM.getValue())).content(Arrays.asList(systemText))).build();
        MultiModalMessageItemImage userImage = new MultiModalMessageItemImage("https://img.alicdn.com/imgextra/i4/O1CN01BjZvwg1Y23CF5qIRB_!!6000000003000-0-tps-3840-2160.jpg");
        MultiModalMessageItemText userText = new MultiModalMessageItemText("\u5e2e\u6211\u5206\u6790\u4e0b\u8fd9\u5f20\u56fe\u662f\u4ec0\u4e48\uff0c\u5e76\u603b\u7ed3\u51fa\u6765");
        Object userMessage = ((MultiModalConversationMessage.MultiModalConversationMessageBuilder)((MultiModalConversationMessage.MultiModalConversationMessageBuilder)MultiModalConversationMessage.builder().role(Role.USER.getValue())).content(Arrays.asList(userImage, userText))).build();
        List<MultiModalConversationMessage> messages = Arrays.asList(systemMessage, userMessage);
        HalfDuplexServiceParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder)MultiModalConversationParam.builder().messages(messages)).model("qwen3-vl-plus")).build();
        Flowable<MultiModalConversationResult> flowable = conversation.streamCall((MultiModalConversationParam)param);
        flowable.blockingForEach(result -> System.out.println(JsonUtils.toJson(result)));
    }

    public static void videoSample() throws ApiException, NoApiKeyException, UploadFileException {
        MultiModalConversation conv = new MultiModalConversation();
        Object systemMessage = ((MultiModalMessage.MultiModalMessageBuilder)((MultiModalMessage.MultiModalMessageBuilder)MultiModalMessage.builder().role(Role.SYSTEM.getValue())).content(Arrays.asList(Collections.singletonMap("text", "You are a helpful assistant.")))).build();
        Object userMessage = ((MultiModalMessage.MultiModalMessageBuilder)((MultiModalMessage.MultiModalMessageBuilder)MultiModalMessage.builder().role(Role.USER.getValue())).content(Arrays.asList(Collections.singletonMap("video", Arrays.asList("/Users/zhiyi/Downloads/vl_data/1.jpg", "/Users/zhiyi/Downloads/vl_data/2.jpg", "/Users/zhiyi/Downloads/vl_data/3.jpg", "/Users/zhiyi/Downloads/vl_data/4.jpg")), Collections.singletonMap("text", "\u63cf\u8ff0\u8fd9\u4e2a\u89c6\u9891\u7684\u5177\u4f53s\u8fc7\u7a0b")))).build();
        HalfDuplexServiceParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().model("qwen-vl-max-latest")).message(systemMessage)).message(userMessage)).build();
        MultiModalConversationResult result = conv.call((MultiModalConversationParam)param);
        System.out.print(JsonUtils.toJson(result));
    }

    public static void streamCallWithToolCalls() throws NoApiKeyException, ApiException, UploadFileException {
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON);
        SchemaGeneratorConfig config = configBuilder.with(Option.EXTRA_OPEN_API_FORMAT_VALUES, new Option[0]).without(Option.FLATTENED_ENUMS_FROM_TOSTRING, new Option[0]).build();
        SchemaGenerator generator = new SchemaGenerator(config);
        ObjectNode jsonSchemaWeather = generator.generateSchema(GetWeatherTool.class, new Type[0]);
        ObjectNode jsonSchemaTime = generator.generateSchema(GetTimeTool.class, new Type[0]);
        Object fdWeather = ((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)FunctionDefinition.builder().name("get_current_weather")).description("\u83b7\u53d6\u6307\u5b9a\u5730\u533a\u7684\u5929\u6c14")).parameters(JsonUtils.parseString(jsonSchemaWeather.toString()).getAsJsonObject())).build();
        Object fdTime = ((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)FunctionDefinition.builder().name("get_current_time")).description("\u83b7\u53d6\u5f53\u524d\u65f6\u523b\u7684\u65f6\u95f4")).parameters(JsonUtils.parseString(jsonSchemaTime.toString()).getAsJsonObject())).build();
        Object systemMsg = ((MultiModalMessage.MultiModalMessageBuilder)((MultiModalMessage.MultiModalMessageBuilder)MultiModalMessage.builder().role(Role.SYSTEM.getValue())).content(Collections.singletonList(Collections.singletonMap("text", "You are a helpful assistant. When asked a question, use tools wherever possible.")))).build();
        Object userMsg = ((MultiModalMessage.MultiModalMessageBuilder)((MultiModalMessage.MultiModalMessageBuilder)MultiModalMessage.builder().role(Role.USER.getValue())).content(Collections.singletonList(Collections.singletonMap("text", "\u676d\u5dde\u5929\u6c14\u600e\u4e48\u6837\uff1f\u73b0\u5728\u51e0\u70b9\u4e86\uff1f")))).build();
        ArrayList<MultiModalMessage> messages = new ArrayList<MultiModalMessage>();
        messages.addAll(Arrays.asList(systemMsg, userMsg));
        HalfDuplexServiceParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().apiKey(System.getenv("DASHSCOPE_API_KEY"))).model(modelName != null ? modelName : "qwen-vl-max-latest")).messages(messages)).modalities(Collections.singletonList("text"))).incrementalOutput(false)).tools(Arrays.asList(((ToolFunction.ToolFunctionBuilder)ToolFunction.builder().function((FunctionDefinition)fdWeather)).build(), ((ToolFunction.ToolFunctionBuilder)ToolFunction.builder().function((FunctionDefinition)fdTime)).build()))).parallelToolCalls(true)).build();
        MultiModalConversation conv = new MultiModalConversation();
        Flowable<MultiModalConversationResult> result = conv.streamCall((MultiModalConversationParam)param);
        result.blockingForEach(message -> System.out.println(JsonUtils.toJson(message)));
    }

    public static void main(String[] args) {
        try {
            MultiModalConversationQwenVL.imageSample();
        }
        catch (ApiException | NoApiKeyException | UploadFileException e) {
            System.out.println(e.getMessage());
        }
        System.exit(0);
    }

    public static class GetTimeTool {
        public String call() {
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String currentTime = "\u5f53\u524d\u65f6\u95f4\uff1a" + now.format(formatter) + "\u3002";
            return currentTime;
        }
    }

    public static class GetWeatherTool {
        private String location;

        public GetWeatherTool(String location) {
            this.location = location;
        }

        public String call() {
            return this.location + "\u4eca\u5929\u662f\u6674\u5929";
        }
    }
}

