/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.refresh;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.client.NacosPropertySource;
import com.alibaba.cloud.nacos.client.NacosPropertySourceBuilder;
import com.alibaba.cloud.nacos.refresh.NacosConfigRefreshEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class NacosPropertySourceRefreshListener
implements BeanPostProcessor,
SmartApplicationListener,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(NacosPropertySourceRefreshListener.class);
    private Map<String, ConfigurationPropertiesBean> beans = new HashMap<String, ConfigurationPropertiesBean>();
    private ApplicationContext applicationContext;
    private AtomicBoolean ready = new AtomicBoolean(false);
    NacosConfigManager nacosConfigManager;

    public NacosPropertySourceRefreshListener(NacosConfigManager nacosConfigManager) {
        this.nacosConfigManager = nacosConfigManager;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ConfigurationPropertiesBean propertiesBean = ConfigurationPropertiesBean.get((ApplicationContext)this.applicationContext, (Object)bean, (String)beanName);
        if (propertiesBean != null) {
            this.beans.put(beanName, propertiesBean);
        }
        return bean;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationReadyEvent.class.isAssignableFrom(eventType) || NacosConfigRefreshEvent.class.isAssignableFrom(eventType);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void handle(ApplicationReadyEvent event) {
        this.ready.compareAndSet(false, true);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            this.handle((ApplicationReadyEvent)event);
        } else if (event instanceof NacosConfigRefreshEvent) {
            this.handle((NacosConfigRefreshEvent)event);
        }
    }

    public void handle(NacosConfigRefreshEvent event) {
        if (this.ready.get() && !this.applicationContext.containsBean("nacosConfigSpringCloudRefreshEventListener")) {
            log.info("Event received " + event.getEventDesc());
            NacosPropertySourceBuilder nacosPropertySourceBuilder = new NacosPropertySourceBuilder(this.nacosConfigManager.getConfigService(), this.nacosConfigManager.getNacosConfigProperties().getTimeout());
            String sourceName = String.join((CharSequence)",", event.dataId, event.group);
            ConfigurableEnvironment environment = ((ConfigurableApplicationContext)this.applicationContext).getEnvironment();
            MutablePropertySources target = environment.getPropertySources();
            PropertySource prevpropertySource = target.get(sourceName);
            if (prevpropertySource instanceof NacosPropertySource) {
                NacosPropertySource newProperSource = nacosPropertySourceBuilder.build(event.getDataId(), event.getGroup(), "properties", ((NacosPropertySource)prevpropertySource).isRefreshable());
                target.replace(sourceName, (PropertySource)newProperSource);
                log.info("Replace Nacos Property Source : " + sourceName);
            }
        }
    }
}

