/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.parse;

import com.ql.util.express.exception.QLCompileException;
import com.ql.util.express.parse.Word;
import java.util.ArrayList;
import java.util.Arrays;

public class WordSplit {
    private WordSplit() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Word[] parse(String[] splitWord, String str) throws Exception {
        if (str == null) {
            return new Word[0];
        }
        int line = 1;
        ArrayList<Word> list = new ArrayList<Word>();
        int i = 0;
        int point = 0;
        int currentLineOffset = 0;
        while (true) {
            int n;
            String[] stringArray;
            boolean isFind;
            block24: {
                int current;
                EscapeState state;
                StringBuilder escapedStr;
                char c;
                block23: {
                    block21: {
                        block22: {
                            if (i >= str.length()) break block21;
                            c = str.charAt(i);
                            if (c != '\"' && c != '\'') break block22;
                            escapedStr = new StringBuilder().append(c);
                            state = EscapeState.CHARS;
                            current = i;
                            break block23;
                        }
                        if (c == '.' && point < i && WordSplit.isNumber(str.substring(point, i))) {
                            ++i;
                            continue;
                        }
                        if (c == ' ' || c == '\r' || c == '\n' || c == '\t' || c == '\f') {
                            if (point < i) {
                                list.add(new Word(str.substring(point, i), line, point - currentLineOffset + 1));
                            }
                            if (c == '\n') {
                                ++line;
                                currentLineOffset = i + 1;
                            }
                            point = ++i;
                            continue;
                        }
                        isFind = false;
                        stringArray = splitWord;
                        n = stringArray.length;
                        break block24;
                    }
                    if (point < i) {
                        list.add(new Word(str.substring(point, i), line, point - currentLineOffset + 1));
                    }
                    Word[] result = new Word[list.size()];
                    list.toArray(result);
                    return result;
                }
                block10: while (++current < str.length()) {
                    char curChar = str.charAt(current);
                    switch (state) {
                        case CHARS: {
                            if (curChar == '\\') {
                                state = EscapeState.MAYBE_ESCAPE;
                                continue block10;
                            }
                            escapedStr.append(curChar);
                            if (curChar != c) break;
                            state = EscapeState.END;
                            break block10;
                        }
                        case MAYBE_ESCAPE: {
                            switch (curChar) {
                                case 'n': {
                                    escapedStr.append('\n');
                                    break;
                                }
                                case 't': {
                                    escapedStr.append('\t');
                                    break;
                                }
                                case 'r': {
                                    escapedStr.append('\r');
                                    break;
                                }
                                default: {
                                    escapedStr.append(curChar);
                                }
                            }
                            state = EscapeState.CHARS;
                        }
                    }
                }
                if (state != EscapeState.END) {
                    throw new QLCompileException("\u5b57\u7b26\u4e32\u6ca1\u6709\u5173\u95ed");
                }
                list.add(new Word(escapedStr.toString(), line, i - currentLineOffset + 1));
                point = i = current + 1;
                continue;
            }
            for (int j = 0; j < n; ++j) {
                String s = stringArray[j];
                int length = s.length();
                if (i + length > str.length() || !str.substring(i, i + length).equals(s)) continue;
                if (point < i) {
                    list.add(new Word(str.substring(point, i), line, point - currentLineOffset + 1));
                }
                list.add(new Word(str.substring(i, i + length), line, i - currentLineOffset + 1));
                point = i += length;
                isFind = true;
                break;
            }
            if (isFind) continue;
            ++i;
        }
    }

    public static void sortSplitWord(String[] splitWord) {
        Arrays.sort(splitWord, (o1, o2) -> Integer.compare(o2.length(), o1.length()));
    }

    protected static boolean isNumber(String str) {
        if (str == null || "".equals(str)) {
            return false;
        }
        char c = str.charAt(0);
        return c >= '0' && c <= '9';
    }

    public static String getPrintInfo(Object[] list, String splitOp) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                buffer.append(splitOp);
            }
            buffer.append("{").append(list[i]).append("}");
        }
        return buffer.toString();
    }

    static enum EscapeState {
        CHARS,
        MAYBE_ESCAPE,
        END;

    }
}

