/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.config;

import com.ql.util.express.config.whitelist.WhiteChecker;
import com.ql.util.express.exception.QLSecurityRiskException;
import java.awt.Desktop;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.HashSet;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.Set;

public class QLExpressRunStrategy {
    private static boolean sandboxMode = false;
    private static List<WhiteChecker> compileWhiteCheckerList = null;
    private static boolean avoidNullPointer = false;
    private static boolean compareNullLessMoreAsFalse = false;
    private static ClassLoader customClassLoader = null;
    private static boolean forbidInvokeSecurityRiskMethods = true;
    private static boolean forbidInvokeSecurityRiskConstructors = true;
    private static final Set<String> SECURITY_RISK_METHOD_LIST = new HashSet<String>();
    private static final Set<String> SECURE_RISK_CONSTRUCTOR_LIST = new HashSet<String>();
    private static Set<String> SECURE_METHOD_LIST = new HashSet<String>();
    private static final Set<String> SECURE_CONSTRUCTOR_LIST = new HashSet<String>();
    private static int maxArrLength = -1;

    private QLExpressRunStrategy() {
        throw new IllegalStateException("Utility class");
    }

    public static void setSandBoxMode(boolean sandboxMode) {
        QLExpressRunStrategy.sandboxMode = sandboxMode;
    }

    public static boolean isSandboxMode() {
        return sandboxMode;
    }

    public static boolean isCompareNullLessMoreAsFalse() {
        return compareNullLessMoreAsFalse;
    }

    public static void setCompareNullLessMoreAsFalse(boolean compareNullLessMoreAsFalse) {
        QLExpressRunStrategy.compareNullLessMoreAsFalse = compareNullLessMoreAsFalse;
    }

    public static boolean isAvoidNullPointer() {
        return avoidNullPointer;
    }

    public static void setAvoidNullPointer(boolean avoidNullPointer) {
        QLExpressRunStrategy.avoidNullPointer = avoidNullPointer;
    }

    public static ClassLoader getCustomClassLoader() {
        return customClassLoader;
    }

    public static void setCustomClassLoader(ClassLoader customClassLoader) {
        QLExpressRunStrategy.customClassLoader = customClassLoader;
    }

    public static boolean isForbidInvokeSecurityRiskMethods() {
        return forbidInvokeSecurityRiskMethods;
    }

    public static void setForbidInvokeSecurityRiskMethods(boolean forbidInvokeSecurityRiskMethods) {
        QLExpressRunStrategy.forbidInvokeSecurityRiskMethods = forbidInvokeSecurityRiskMethods;
    }

    public static boolean isForbidInvokeSecurityRiskConstructors() {
        return forbidInvokeSecurityRiskConstructors;
    }

    public static void setForbidInvokeSecurityRiskConstructors(boolean forbidInvokeSecurityRiskConstructors) {
        QLExpressRunStrategy.forbidInvokeSecurityRiskConstructors = forbidInvokeSecurityRiskConstructors;
    }

    public static void addSecurityRiskMethod(Class<?> clazz, String methodName) {
        SECURITY_RISK_METHOD_LIST.add(clazz.getName() + "." + methodName);
    }

    public static void setSecureMethods(Set<String> secureMethods) {
        SECURE_METHOD_LIST = secureMethods;
    }

    public static void addSecureMethod(Class<?> clazz, String methodName) {
        SECURE_METHOD_LIST.add(clazz.getName() + "." + methodName);
    }

    public static void addRiskSecureConstructor(Class<?> clazz) {
        SECURE_RISK_CONSTRUCTOR_LIST.add(clazz.getName());
    }

    public static void addSecureConstructor(Class<?> clazz) {
        SECURE_CONSTRUCTOR_LIST.add(clazz.getName());
    }

    public static void assertSecurityRiskMethod(Method method) throws QLSecurityRiskException {
        if (!forbidInvokeSecurityRiskMethods || method == null) {
            return;
        }
        String fullMethodName = method.getDeclaringClass().getName() + "." + method.getName();
        if (SECURE_METHOD_LIST != null && !SECURE_METHOD_LIST.isEmpty()) {
            if (!SECURE_METHOD_LIST.contains(fullMethodName)) {
                throw new QLSecurityRiskException("\u4f7f\u7528QLExpress\u8c03\u7528\u4e86\u4e0d\u5b89\u5168\u7684\u7cfb\u7edf\u65b9\u6cd5:" + method);
            }
            return;
        }
        if (SECURITY_RISK_METHOD_LIST.contains(fullMethodName)) {
            throw new QLSecurityRiskException("\u4f7f\u7528QLExpress\u8c03\u7528\u4e86\u4e0d\u5b89\u5168\u7684\u7cfb\u7edf\u65b9\u6cd5:" + method);
        }
    }

    public static void assertSecurityRiskConstructor(Constructor constructor) throws QLSecurityRiskException {
        if (!forbidInvokeSecurityRiskConstructors || constructor == null) {
            return;
        }
        String fullConstructorName = constructor.getDeclaringClass().getName();
        if (!SECURE_CONSTRUCTOR_LIST.isEmpty()) {
            if (!SECURE_CONSTRUCTOR_LIST.contains(fullConstructorName)) {
                throw new QLSecurityRiskException("\u4f7f\u7528QLExpress\u8c03\u7528\u4e86\u4e0d\u5b89\u5168\u7684\u7cfb\u7edf\u6784\u9020\u51fd\u6578:" + constructor);
            }
            return;
        }
        if (SECURE_RISK_CONSTRUCTOR_LIST.contains(fullConstructorName)) {
            throw new QLSecurityRiskException("\u4f7f\u7528QLExpress\u8c03\u7528\u4e86\u4e0d\u5b89\u5168\u7684\u7cfb\u7edf\u6784\u9020\u51fd\u6578:" + constructor);
        }
    }

    public static boolean checkWhiteClassList(Class<?> clazz) {
        if (compileWhiteCheckerList == null) {
            return true;
        }
        for (WhiteChecker whiteChecker : compileWhiteCheckerList) {
            if (!whiteChecker.check(clazz)) continue;
            return true;
        }
        return false;
    }

    public static void setCompileWhiteCheckerList(List<WhiteChecker> compileWhiteCheckerList) {
        QLExpressRunStrategy.compileWhiteCheckerList = compileWhiteCheckerList;
    }

    public static void setMaxArrLength(int maxArrLength) {
        QLExpressRunStrategy.maxArrLength = maxArrLength;
    }

    public static boolean checkArrLength(int arrLen) {
        return maxArrLength == -1 || arrLen <= maxArrLength;
    }

    static {
        SECURITY_RISK_METHOD_LIST.add(System.class.getName() + ".exit");
        SECURITY_RISK_METHOD_LIST.add(Runtime.getRuntime().getClass().getName() + ".exec");
        SECURITY_RISK_METHOD_LIST.add(ProcessBuilder.class.getName() + ".start");
        SECURITY_RISK_METHOD_LIST.add(Method.class.getName() + ".invoke");
        SECURITY_RISK_METHOD_LIST.add(Class.class.getName() + ".forName");
        SECURITY_RISK_METHOD_LIST.add(ClassLoader.class.getName() + ".loadClass");
        SECURITY_RISK_METHOD_LIST.add(ClassLoader.class.getName() + ".findClass");
        SECURITY_RISK_METHOD_LIST.add(ClassLoader.class.getName() + ".defineClass");
        SECURITY_RISK_METHOD_LIST.add(ClassLoader.class.getName() + ".getSystemClassLoader");
        SECURITY_RISK_METHOD_LIST.add("javax.naming.InitialContext.lookup");
        SECURITY_RISK_METHOD_LIST.add("com.sun.rowset.JdbcRowSetImpl.setDataSourceName");
        SECURITY_RISK_METHOD_LIST.add("com.sun.rowset.JdbcRowSetImpl.setAutoCommit");
        SECURITY_RISK_METHOD_LIST.add("jdk.jshell.JShell.create");
        SECURITY_RISK_METHOD_LIST.add("javax.script.ScriptEngineManager.getEngineByName");
        SECURITY_RISK_METHOD_LIST.add("org.springframework.jndi.JndiLocatorDelegate.lookup");
        for (Method method : QLExpressRunStrategy.class.getMethods()) {
            SECURITY_RISK_METHOD_LIST.add(QLExpressRunStrategy.class.getName() + "." + method.getName());
        }
        QLExpressRunStrategy.addRiskSecureConstructor(ProcessBuilder.class);
        QLExpressRunStrategy.addRiskSecureConstructor(Socket.class);
        QLExpressRunStrategy.addRiskSecureConstructor(Desktop.class);
        QLExpressRunStrategy.addRiskSecureConstructor(PropertyResourceBundle.class);
    }
}

