/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.qwen;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.BaseLlmClientListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.impl.SseClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.LogUtil;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.qwen.QwenLlmConfig;
import com.agentsflex.llm.qwen.QwenLlmUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.HashMap;

public class QwenLlm
extends BaseLlm<QwenLlmConfig> {
    private final HttpClient httpClient = new HttpClient();
    public AiMessageParser aiMessageParser = QwenLlmUtil.getAiMessageParser(false);
    public AiMessageParser streamMessageParser = QwenLlmUtil.getAiMessageParser(true);

    public QwenLlm(QwenLlmConfig config) {
        super((LlmConfig)config);
    }

    public AiMessageResponse chat(Prompt prompt, ChatOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((QwenLlmConfig)this.getConfig()).getApiKey());
        String payload = QwenLlmUtil.promptToPayload(prompt, (QwenLlmConfig)this.config, options, false);
        String endpoint = ((QwenLlmConfig)this.config).getEndpoint();
        String response = this.httpClient.post(endpoint + "/compatible-mode/v1/chat/completions", headers, payload);
        if (((QwenLlmConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            return AiMessageResponse.error((Prompt)prompt, (String)response, (String)"no content for response.");
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        JSONObject error = jsonObject.getJSONObject("error");
        AiMessageResponse messageResponse = new AiMessageResponse(prompt, response, (AiMessage)this.aiMessageParser.parse((Object)jsonObject));
        if (error != null && !error.isEmpty()) {
            messageResponse.setError(true);
            messageResponse.setErrorMessage(error.getString("message"));
            messageResponse.setErrorType(error.getString("type"));
            messageResponse.setErrorCode(error.getString("code"));
        }
        return messageResponse;
    }

    public void chatStream(Prompt prompt, StreamResponseListener listener, ChatOptions options) {
        SseClient llmClient = new SseClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((QwenLlmConfig)this.getConfig()).getApiKey());
        headers.put("X-DashScope-SSE", "enable");
        String payload = QwenLlmUtil.promptToPayload(prompt, (QwenLlmConfig)this.config, options, true);
        BaseLlmClientListener clientListener = new BaseLlmClientListener((Llm)this, (LlmClient)llmClient, listener, prompt, this.streamMessageParser);
        String endpoint = ((QwenLlmConfig)this.config).getEndpoint();
        llmClient.start(endpoint + "/compatible-mode/v1/chat/completions", headers, payload, (LlmClientListener)clientListener, this.config);
    }

    public VectorData embed(Document document, EmbeddingOptions options) {
        String payload = QwenLlmUtil.promptToEnabledPayload(document, options, (QwenLlmConfig)this.config);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((QwenLlmConfig)this.getConfig()).getApiKey());
        String url = ((QwenLlmConfig)this.config).getEndpoint() + "/compatible-mode/v1/embeddings";
        String response = this.httpClient.post(url, headers, payload);
        if (((QwenLlmConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            return null;
        }
        VectorData vectorData = new VectorData();
        double[] embedding = (double[])JSONPath.read((String)response, (String)"$.data[0].embedding", double[].class);
        vectorData.setVector(embedding);
        return vectorData;
    }
}

