/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.image.qwen;

import com.agentsflex.core.image.EditImageRequest;
import com.agentsflex.core.image.GenerateImageRequest;
import com.agentsflex.core.image.ImageModel;
import com.agentsflex.core.image.ImageResponse;
import com.agentsflex.core.image.VaryImageRequest;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.image.qwen.QwenImageModelConfig;
import com.alibaba.dashscope.aigc.imagesynthesis.ImageSynthesis;
import com.alibaba.dashscope.aigc.imagesynthesis.ImageSynthesisParam;
import com.alibaba.dashscope.aigc.imagesynthesis.ImageSynthesisResult;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QwenImageModel
implements ImageModel {
    private static final Logger LOG = LoggerFactory.getLogger(QwenImageModel.class);
    private final QwenImageModelConfig config;
    private final HttpClient httpClient = new HttpClient();

    public QwenImageModel(QwenImageModelConfig config) {
        this.config = config;
    }

    public ImageResponse generate(GenerateImageRequest request) {
        try {
            ImageSynthesis is = new ImageSynthesis();
            ImageSynthesisParam param = ((ImageSynthesisParam.ImageSynthesisParamBuilder)((ImageSynthesisParam.ImageSynthesisParamBuilder)ImageSynthesisParam.builder().apiKey(this.config.getApiKey())).model(null != request.getModel() ? request.getModel() : this.config.getModel())).size(request.getSize()).prompt(request.getPrompt()).seed(Integer.valueOf(String.valueOf(request.getOptionOrDefault("seed", (Object)1)))).build();
            ImageSynthesisResult result = is.call(param);
            if (Objects.isNull(result.getOutput().getResults())) {
                return ImageResponse.error((String)result.getOutput().getMessage());
            }
            ImageResponse imageResponse = new ImageResponse();
            for (Map item : result.getOutput().getResults()) {
                imageResponse.addImage((String)item.get("url"));
            }
            return imageResponse;
        }
        catch (Exception e) {
            return ImageResponse.error((String)e.getMessage());
        }
    }

    public ImageResponse img2imggenerate(GenerateImageRequest request) {
        throw new IllegalStateException("QwenImageModel Can not support img2imggenerate.");
    }

    public ImageResponse edit(EditImageRequest request) {
        throw new IllegalStateException("QwenImageModel Can not support edit image.");
    }

    public ImageResponse vary(VaryImageRequest request) {
        throw new IllegalStateException("QwenImageModel Can not support vary image.");
    }
}

